//
//  TAVDraftClipSource.h
//  TAVMagic
//
//  Created by chavezchen on 2024/10/17.
//
#import <TAVMagic/TAVDraftComponent.h>
#import <TAVMagic/TAVEditorDefinitions.h>

NS_ASSUME_NONNULL_BEGIN
@class TAVMediaAssetCropInfo;
@interface TAVDraftClipSource : TAVDraftComponent

@property (nonatomic, assign) int clipIndex;
@property (nonatomic, assign) TAVEditorMediaType mediaType;
@property (nonatomic, assign) float volume;
@property (nonatomic, assign) float speed;
@property (nonatomic, assign) int rotation;
@property (nonatomic, assign) CGAffineTransform clipTransform;
@property (nonatomic, assign) CGSize clipSize;
@property (nonatomic, strong) TAVMediaAssetCropInfo *cropInfo; // 裁剪页的信息

- (instancetype)initWithPath:(NSString *)path mediaType:(TAVEditorMediaType)mediaType;
+ (instancetype)clipSourceWithPath:(NSString *)path mediaType:(TAVEditorMediaType)mediaType;
@end

NS_ASSUME_NONNULL_END
