//
//  TAVDraftComponent.h
//  TAVMagic
//
//  Created by chavezchen on 2024/10/17.
//

#import <Foundation/Foundation.h>
#import <CoreMedia/CoreMedia.h>


NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSUInteger, TAVDraftComponentType) {
    TAVDraftComponentTypeClip,
    TAVDraftComponentTypeBgm,
    TAVDraftComponentTypeVoiceover,
    TAVDraftComponentTypeLut,
    TAVDraftComponentTypeMotion,
    TAVDraftComponentTypeSticker,
    TAVDraftComponentTypePip,
};

@interface TAVDraftComponent : NSObject<NSCopying>

@property (nonatomic, assign) int componentId;
@property (nonatomic, copy) NSString *path;                 // 输入源
@property (nonatomic, assign) TAVDraftComponentType type;   // 类型
@property (nonatomic, assign) CMTimeRange sourceUseRange;   // 组件资源使用的时间区间
@property (nonatomic, assign) CMTime startAtVideoTime;      // 组件自身的启始时长

- (instancetype)initWithPath:(NSString *)path;
- (BOOL)diffProperties:(TAVDraftComponent *)other;

@end

NS_ASSUME_NONNULL_END
