//
//  TAVDraftLoadingResult.h
//  TAVMagic
//
//  Created by penghuixu on 2025/1/7.
//

#import <Foundation/Foundation.h>
#import <TAVMagic/TAVDraftComponent.h>

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, TAVDraftLoadingError) {
    TAVDraftLoadingErrorUnknown = -1,
    TAVDraftLoadingErrorSDKInternal = 100,
    TAVDraftLoadingErrorResourceNotFound = 101,
    TAVDraftLoadingErrorSDKInternalResourceInvalid = 102,
};

@interface TAVComponentLoadingError : NSObject
- (instancetype)initWithComponent:(TAVDraftComponent *)component errorCode:(TAVDraftLoadingError)errorCode;
@property (nonatomic, strong) TAVDraftComponent * component;
@property (nonatomic, assign) TAVDraftLoadingError errorCode;
@end

@interface TAVDraftLoadingResult : NSObject
@property (nonatomic, strong) NSMutableArray<TAVComponentLoadingError *> *errors;

- (BOOL)isSuccess;
- (NSArray<TAVComponentLoadingError *> *)getErrors;

@end

NS_ASSUME_NONNULL_END
