//
//  TAVDraftPip.h
//  TAVMagic
//
//  Created by chavezchen on 2024/10/17.
//

#import <TAVMagic/TAVDraftWidget.h>

NS_ASSUME_NONNULL_BEGIN
@class TAVMediaPipItem;
@interface TAVDraftPip : TAVDraftWidget
@property (nonatomic, weak) TAVMediaPipItem *pipItem;

@property (nonatomic, copy) NSString *pipId;
@property (nonatomic, assign) float volume;
@property (nonatomic, assign) float speed;
@property (nonatomic, assign) CGSize naturalSize;
@property (nonatomic, assign) NSInteger mediaType;
// 轨道索引，用于UI业务显示
@property (nonatomic, assign) NSInteger trackIndex;
// 扩展字段
@property (nonatomic, strong) NSDictionary *extraInfo;

- (instancetype)initWithPipItem:(TAVMediaPipItem *)pipItem;
- (void)removeSelfKvo;
- (void)addKvo:(TAVMediaPipItem *)item;
@end

NS_ASSUME_NONNULL_END
