//
//  TAVDraftSticker.h
//  TAVMagic
//
//  Created by chavezchen on 2024/10/17.
//
#import <UIKit/UIKit.h>
#import <TAVMagic/TAVDraftWidget.h>
#import <TAVMagic/ITAVStickerManager.h>

NS_ASSUME_NONNULL_BEGIN
@class TAVMediaStickerItem,TAVMediaStickerFont;
@interface TAVDraftSticker : TAVDraftWidget
@property (nonatomic, weak) TAVMediaStickerItem *stickerItem;

@property (nonatomic, assign) TAVStickerItemType stickerType;        // 贴纸类型
@property (nonatomic, assign) TAVStickerItemImageSubType subImageType; // 图片类型贴纸的子类型
@property (nonatomic, strong) NSString *stickerID;    // 贴纸ID
@property (nonatomic, copy) NSString *text;                     // 文本贴纸的文本
@property (nonatomic, strong) NSString *defaultText;  // 文本贴纸的默认文本
@property (nonatomic, strong) UIColor *textColor;               // 文本贴纸的文字颜色
@property (nonatomic, strong) UIColor *bgColor;                 // 整个贴纸背景色
@property (nonatomic, assign) NSInteger textMaxLength;           // 支持的可输入文字最大字数
@property (nonatomic, strong) TAVMediaStickerFont *stickerFont; // 字体
@property (nonatomic, assign) NSUInteger contentMode; //文字框的影响区域应该是整个贴纸还是只是文字区域

/// 描边
@property (nonatomic, assign) BOOL applyTextStroke;                 //开启文本描边
@property (nonatomic, assign) CGFloat textStrokeWidth;              //文本描边厚度
@property (nonatomic, strong) UIColor *textStrokeColor;             //文本描边颜色

/// 文本背景
@property (nonatomic, strong) UIColor *textBgColor;                 //文本背景颜色
@property (nonatomic, assign) CGFloat textBgAlpha;                  //文本背景透明度，取值范围 0 - 1

/// 贴纸的scale 对应 sticker的scale
@property (nonatomic, assign) CGFloat stickerScale;

/// 对应sticker的edgeInset
@property (nonatomic, assign) UIEdgeInsets stickerEdgeInsets;
// 渲染顺序
@property (nonatomic, assign) NSInteger layerIndex;
// 轨道索引，用于UI业务显示
@property (nonatomic, assign) NSInteger trackIndex;
// 扩展字段
@property (nonatomic, strong) NSDictionary *extraInfo;

- (instancetype)initWithStickerItem:(TAVMediaStickerItem *)stickerItem;
- (void)addKvo:(TAVMediaStickerItem *)item;
- (void)removeSelfKvo;
@end

NS_ASSUME_NONNULL_END
