//
//  QHPFontManager.h
//  TAVStickerKit
//
//  Created by Victor Tian on 2018/8/8.
//  Copyright © 2018 Tencent Inc. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <libpag/PAGFont.h>

@class TAVStickerTextItem;

@interface TAVFontManager : NSObject

+ (TAVFontManager *)sharedInstance;

- (BOOL)registerFontWithTextItem:(TAVStickerTextItem *)textItem;
- (PAGFont *)fontWithTextItem:(TAVStickerTextItem *)textItem;
- (PAGFont *)fontWithPath:(NSString *)fontPath;
- (PAGFont *)fontWithFontPath:(NSString *)fontPath fontFamily:(NSString *)fontFamily fontStyle:(NSString *)fontStyle;
- (NSMutableDictionary *)getFontInfo;

/// 通过fontFamily以及fontStye来查找已注册的字体
/// @param fontFamily
/// @param fontStyle
- (PAGFont *)fontWithFamily:(NSString *)fontFamily style:(NSString *)fontStyle;
@end
