//
//  TAVMediaAssetCropInfo.h
//  TAVCut
//
//  Created by ashli on 2021/8/20.
//  Copyright © 2021 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <YYModel/NSObject+YYModel.h>

NS_ASSUME_NONNULL_BEGIN
#define TAV_ROUNDF(x) (round((x) * 100000)) / 100000



@interface TAVMediaAssetCropInfo : NSObject<YYModel, NSCopying>
/// 旋转刻度
@property (nonatomic, assign) CGFloat angleValue;
/// 图片偏移
@property (nonatomic, assign) CGPoint photoContentOffset;
/// 缩放比例
@property (nonatomic, assign) CGFloat zoomScale;
/// 比例类型，用于恢复比例按钮的选项
@property (nonatomic, assign) int ratioType;
/// crop尺寸，不考虑旋转，用于恢复框的比例
@property (nonatomic, assign) CGSize cropSize;
@property (nonatomic, assign) CGRect cropRect;
/// 90度旋转的次数
@property (nonatomic, assign) NSInteger ratateAngleTimes;

- (BOOL)tav_isEqual:(TAVMediaAssetCropInfo *)other;

@end

NS_ASSUME_NONNULL_END
