//
//  WSEffectItem.h
//  TAVStickerKit_Example
//
//  Created by Victor Tian on 2019/9/26.
//  Copyright © 2019 VictorTian. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "TAVMediaBaseEffect.h"
#import <AVFoundation/AVFoundation.h>
//#import "TAVStickerKit.h"
#import "TAVSticker.h"
#import "TAVStickerModel.h"


NS_ASSUME_NONNULL_BEGIN

/** 贴纸渲染层级从0～1000 */
UIKIT_EXTERN const TAVStickerIndex TAVMediaEffectItemLevelSticker;
/** 水印渲染层级从1000～2000 */
UIKIT_EXTERN const TAVStickerIndex TAVMediaEffectItemLevelWatermark;
/** 片尾渲染层级从2000～3000 */
UIKIT_EXTERN const TAVStickerIndex TAVMediaEffectItemLevelEnding;

@interface TAVMediaEffectItem : TAVMediaBaseEffect<TAVStickerModel> {
    TAVSticker *_sticker;
}

/// 初始化方法
/// @param sticker 外部创建的TAVStickr对象
- (instancetype)initWithSticker:(TAVSticker *)sticker;

/// 使用filePath创建，用于素材形式为Template.json模式
/// @param filePath template.json的filePath
/// @param timeRange 时间区间
- (instancetype)initWithFilePath:(NSString *)filePath timeRange:(CMTimeRange)timeRange;

/**
 效果的播放速度
 */
@property (nonatomic, assign) CGFloat speed;
/**
 贴纸位置与大小，归一化数值，{centerX, centerY, width, height}
 */
@property (nonatomic, assign) CGRect scaleRect;
/**
 旋转角度
 */
@property (nonatomic, assign) CGFloat rotation;
/**
 PAG模型对象
 */
@property (nonatomic, strong, readonly) TAVSticker *sticker;

/// 源图片更新pag图层PAGImage的scaleMode
@property (nonatomic, assign) PAGScaleMode pagScaleMode;

@property (nonatomic, assign) TAVStickerScaleMode scaleMode;

//// 对于TAVMediaEffectItem中的sticker，现在内部强制设为TAVStickerScaleModeAspectFill。增加改属性，为YES时，外部可以改变
@property (nonatomic, assign) BOOL canManuallyUpdateScaleMode;

/// 对应sticker.hideActiveMode
@property (nonatomic, assign) BOOL hideActiveMode;

@end

NS_ASSUME_NONNULL_END
