//
//  TAVMediaEntityGroupArrangeConfig.h
//  TAVCut
//
//  Created by cillyflyxu on 2022/6/18.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN
/// 此处Enum的排序会决定Container在EntityTree中的顺序
typedef NS_ENUM (NSUInteger, TAVMediaGroup) {
    TAVMediaGroupLUT = 0,          // 滤镜
    TAVMediaGroupAILightAssetSticker = 1, // 子素材AI能力贴纸
    TAVMediaGroupFaceEffect = 2,   // 人脸特效
    TAVMediaGroupScreenEffect = 3, // 画面特效
    TAVMediaGroupSticker = 4,      // 普通贴纸
};
@interface TAVMediaEntityGroupArrangeConfig : NSObject

/// 获取Group的命名
/// @param config 配置
+ (NSString*)groupNameIdentifiter:(TAVMediaGroup)config;

/// 通过名称获取到当前group预期的位置顺序
/// @param groupName group name
+ (NSInteger)indexForGroupName:(NSString *)groupName;

@end

NS_ASSUME_NONNULL_END
