//
//  TAVMediaSubEffect.h
//  TAVCut
//
//  Created by cillyflyxu on 2022/6/1.
//  Copyright © 2022 Tencent. All rights reserved.
//

#import <AVFoundation/AVFoundation.h>
#import <Foundation/Foundation.h>
#import <YYModel/NSObject+YYModel.h>

#import "NSObject+TAVMD5.h"

NS_ASSUME_NONNULL_BEGIN
@class LightAsset;
@class LightAssetDataContext;
@class LAKEntity;

/// 子素材描述类型
@interface TAVMediaLightAssetFragmentItem : NSObject<YYModel, NSCopying>

/// 子素材相对父节点的时间区间
@property (nonatomic, assign) CMTimeRange timeRange;

/// 返回子素材所在目录
@property (nonatomic, copy) NSString *resourcePath;

/// LightAsset 从Template.json构建
- (LightAsset *)lightAsset;

/// 是否子素材功能开启
- (BOOL)isLightAssetEnable;

/// 子素材描述的AI能力
- (NSArray<NSString *> *)AIBundles;

/// 是否需要AI能力
- (BOOL)isNeedAiAbility;

/// 获取在子素材中设定的主编辑的Entityid
- (NSInteger)mainEntityIdWithRootEntity:(LAKEntity *)rootEntity;
@end

NS_ASSUME_NONNULL_END
