//
//  TAVMediaPipItem.h
//  TAVCut
//
//  Created by chavezchen on 2024/9/23.
//

#import "TAVMediaBaseEffect.h"
NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, TAVMediaPipItemType) {
    /** 视频 */
    TAVMediaPipItemTypeVideo   = 0,
    /** 图片 */
    TAVMediaPipItemTypeImage   = 1
};

@interface TAVMediaPipItem : TAVMediaBaseEffect

// 唯一标识
@property (nonatomic, copy) NSString *pipId;
/**
 画中画位置与大小，归一化数值，{centerX, centerY, width, height}
 */
@property (nonatomic, assign) CGRect scaleRect;
/**
 旋转角度 (M_PI 3.14为360度)。
 */
@property (nonatomic, assign) CGFloat rotation;

@property (nonatomic, assign) float speed;

@property (nonatomic, assign) float volume;
/// 视频分辨率
@property (nonatomic, assign) CGSize naturalSize;

@property (nonatomic, assign, readonly) CMTimeRange timeRange;
// 在时间轴的开始时间
@property (nonatomic, assign) CMTime startTime;
/// 原始资源的时间区间,比如10s视频，一直都是[0,10]，业务一般不修改
@property (nonatomic, assign) CMTimeRange sourceRange;
/// 资源实际的范围，比如10s的视频，使用了其中的3s-7s，这个就是[3,4]
@property (nonatomic, assign) CMTimeRange sourceUseRange;

@property (nonatomic, assign) TAVMediaPipItemType mediaType;
/** 基类有此扩展字段可使用 */
//@property (nonatomic, strong) NSDictionary *extraInfo;

- (CGRect)contentFrameInRenderRect:(CGRect)renderRect;
- (void)updateFrame:(CGRect)frame inRenderRect:(CGRect)renderRect;
- (void)updateFrame:(CGRect)frame inRenderSize:(CGSize)renderSize;
@end

NS_ASSUME_NONNULL_END
