//
//  TAVPlayerDefine.h
//  TAVStickerKit
//
//  Created by Victor Tian on 2019/4/26.
//  Copyright © 2019 tencent. All rights reserved.
//

#ifndef TAVPlayerDefine_h
#define TAVPlayerDefine_h

typedef NS_ENUM(NSInteger, TAVPlaybackState) {
    /** 初始化 */
    TAVPlaybackStateInit,
    /** 加载准备中 */
    TAVPlaybackStatePreparing,
    /** 已就绪，即将播放/暂停 */
    TAVPlaybackStateReady,
    /** 缓冲加载中 */
    TAVPlaybackStateLoading,
    /** 播放中 */
    TAVPlaybackStatePlaying,
    /** 暂停 */
    TAVPlaybackStatePaused,
    /** 播放结束 */
    TAVPlaybackStateFinished,
    /** 播放停止 */
    TAVPlaybackStateStopped,
    /** 播放器已销毁 */
    TAVPlaybackStateDestoryed,
    /** 播放失败 */
    TAVPlaybackStateFailed,
};

typedef NS_ENUM(NSUInteger, TAVPlayerFillMode) {
    TAVPlayerFillModeAspectFit,
    TAVPlayerFillModeAspectFill,
    TAVPlayerFillModeFill,
};

typedef NS_ENUM(NSUInteger, TAVMediaPlayerError) {
    TAVMediaPlayerErrorUnknown,
    TAVMediaPlayerErrorEmptyItem,
    TAVMediaPlayerErrorLoadFailed,
};

#endif /* TAVPlayerDefine_h */
