//
//  TAVPlayerProtocal.h
//  TAVStickerKit_Example
//
//  Created by Victor Tian on 2019/4/28.
//  Copyright © 2019 tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <AVFoundation/AVFoundation.h>

NS_ASSUME_NONNULL_BEGIN

@protocol TAVPlayerProtocal <NSObject>

@end

@protocol TAVPlayerControlPanelDelegate;
@protocol TAVPlayerControlPanel <NSObject>

@required
/**
 *  代理
 */
@property (nonatomic, weak) id<TAVPlayerControlPanelDelegate> delegate;
/**
 进度条是否拖拽中
 */
@property (nonatomic, assign, getter=isDragging) BOOL dragging;
/**
 *  是否播放中
 */
@property (nonatomic, assign, getter=isPlaying) BOOL playing;
/**
 *  当前进度
 */
@property (nonatomic, assign) CMTime progress;
/**
 *  总时长
 */
@property (nonatomic, assign) CMTime duration;

@optional
/**
 *  播放速度
 */
@property (nonatomic, assign) CGFloat speed;

@end

@protocol TAVPlayerControlPanelDelegate <NSObject>

@optional

- (void)controlPanelDidClickPlayItem:(UIView<TAVPlayerControlPanel> *)playerControl;
- (void)controlPanelDidBeginDragging:(UIView<TAVPlayerControlPanel> *)playerControl;
- (void)controlPanelDidEndDragging:(UIView<TAVPlayerControlPanel> *)playerControl;
- (void)controlPanel:(UIView<TAVPlayerControlPanel> *)playerControl
       didSeekToTime:(CMTime)seekTime;

@end

NS_ASSUME_NONNULL_END
