//
//  TAVPlayerViewController.h
//  TAVStickerKit_Example
//
//  Created by Victor Tian on 2019/4/26.
//  Copyright © 2019 tencent. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "TAVMediaPlayer.h"
#import "TAVPlayerProtocal.h"
#import "TAVPlayerDefine.h"

NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSUInteger, TAVPlayerResumeMode) {
    /** Auto resume the playback state when the device has been active. */
    TAVPlayerResumeModeDefault,
    /** Auto play when the device has been active. */
    TAVPlayerResumeModePlay,
    /** Auto pause when the device has been active. */
    TAVPlayerResumeModePause,
};

@class TAVPlayerViewController, TAVMediaPlayerView;
@protocol TAVMediaViewProtocol;

@protocol TAVPlayerViewControllerDelegate <NSObject>

@optional
- (void)playerControlerDidBeginDragging:(TAVPlayerViewController *)playerController;
- (void)playerControlerDidEndDragging:(TAVPlayerViewController *)playerController;
- (void)playerControler:(TAVPlayerViewController *)playerController
     videoRectDidChange:(CGRect)videoRect;
- (void)playerControlerReadyForDisplay:(TAVPlayerViewController *)playerController;

@end

@interface TAVPlayerViewController : UIViewController <TAVMediaPlayerObserver, TAVPlayerControlPanelDelegate>

@property (nonatomic, strong, readonly) TAVMediaPlayer *mediaPlayer;
@property (nonatomic, weak) id<TAVPlayerViewControllerDelegate> delegate;
@property (nonatomic, strong) UIView<TAVPlayerControlPanel> *controlPanel;
@property (nonatomic, strong) UIView<TAVMediaViewProtocol> *playerView;
@property (nonatomic, strong) UIColor *backgroundColor;

@property (nonatomic, assign, readonly) CGRect videoRect;
@property (nonatomic, assign) TAVPlayerFillMode fillMode;
/**
 Control the action of the playback when the device has been active.
*/
@property (nonatomic, assign) TAVPlayerResumeMode resumeMode;
@property (nonatomic, assign) BOOL controlPanelHidden;
/**
 Disable fake image when playerItem changed. Deafults is NO.
 */
@property (nonatomic, assign) BOOL disableFakeImage;

/**
 Force not to display fake image anytime. Deafults is NO.
 */
@property (nonatomic, assign) BOOL forceIgnoreFakeImage;

/**
 Use MTKView Display Video. Deafults is NO. Must Not changed when display.
 */
@property (nonatomic, assign) BOOL useMetalViewToDisplay;

/**
 Auto seek to last playerItem currentTime When change AVPlayerItem. Deafults is NO.
 */
@property (nonatomic, assign) BOOL autoSeekLastPlayerItemTime;

/**
 Auto player auto pause when the application state is not activate. Deafults is NO.
 */
@property (nonatomic, assign) BOOL autoPauseWhenNotActivate;

/**
 Take a Screenshot at current time.
 
 @return The Screenshot for the specified time.
 */
- (UIImage *)takeScreenshot;
/**
 Async Take a Scree1nshot at specified time.
 
 @param time Screenshot for the specified time.
 @param completion finish block
 */
- (void)asyncTakeScreenshotWithTime:(CMTime)time
                         completion:(nullable void (^)(UIImage *image))completion;
/**
 Tells the delegate that the video rect has changed.
*/
- (void)notifyVideoRectDidChange;

@end

NS_ASSUME_NONNULL_END
