//
//  TAVMediaStickerItem.h
//  TAVCut
//
//  Created by Victor Tian on 2019/10/23.
//  Copyright © 2019 tencent. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "TAVMediaEffectItem.h"
#import "TAVMediaStickerDefine.h"

@class LightDataSource,TAVMediaTTSItem,TAVTrackStickerInfo,TAVMediaEffectItem;

NS_ASSUME_NONNULL_BEGIN

@interface TAVMediaStickerFont : NSObject<NSCopying>
// A string with the name of the font family.
@property (nonatomic, copy) NSString *fontFamily;
// A string with the style information — e.g., “bold”, “italic”.
@property (nonatomic, copy) NSString *fontStyle;
// pagFont Path
@property (nonatomic, copy) NSString *fontPath;

+ (instancetype)stickerFont:(NSString*)fontPath
                     family:(NSString*)fontFamily
                      style:(NSString*)fontStyle;

@end


extern NSString * const gTAVMediaStickerItemBgLayer;                //背景 layer name
extern NSString * const gTAVMediaStickerItemCustomImagePathKey;     //自定义贴纸路径
extern NSString * const gTAVMediaStickerItemMainPag;                //上屏pag
extern NSString * const gTAVMediaStickerItemImagePathKey;           //图片贴纸图片资源路径

@interface TAVMediaStickerItem : TAVMediaEffectItem
@property (nonatomic, assign) TAVStickerType stickerType;           // 贴纸类型
@property (nonatomic, assign) TAVStickerImageSubType subImageType;  // 图片类型贴纸的子类型
@property (nonatomic, copy) NSString *stickerID;                    // 贴纸ID
@property (nonatomic, copy, readonly) NSString *stickerPath;        // 贴纸路径
@property (nonatomic, copy) NSString *imageFilePath;                // 图片路径
@property (nonatomic, copy) NSString *text;                         // 文本贴纸的文本
@property (nonatomic, copy) NSString *defaultText;                  // 文本贴纸的默认文本
@property (nonatomic, strong) UIColor *textColor;                   // 文本贴纸的文字颜色
@property (nonatomic, strong) UIColor *bgColor;                     // 整个贴纸背景色
@property (nonatomic, strong) TAVMediaStickerFont *stickerFont;     // 文本字体
@property (nonatomic, assign) NSInteger textMaxLength;              // 支持的可输入文字最大字数
@property (nonatomic, assign) TAVStickerContentMode contentMode; // 文字框的影响区域应该是整个贴纸还是只是文字区域
@property (nonatomic, assign) TAVStickerAnimationMode animationMode;// 贴纸动效播放模式
/// 描边
@property (nonatomic, assign) BOOL applyTextStroke;                 // 开启文本描边
@property (nonatomic, assign) CGFloat textStrokeWidth;              // 文本描边厚度
@property (nonatomic, strong) UIColor *textStrokeColor;             // 文本描边颜色
/// 文本背景
@property (nonatomic, strong) UIColor *textBgColor;                 // 文本背景颜色
@property (nonatomic, assign) CGFloat textBgAlpha;                  // 文本背景透明度，范围 0 - 1
/** 基类有此扩展字段可使用 */
//@property (nonatomic, strong) NSDictionary *extraInfo;
@property (nonatomic, assign) CGFloat stickerScale;
@property (nonatomic, assign) UIEdgeInsets stickerEdgeInsets;
@property (nonatomic, copy) NSString *mosaicGraffitiPath;           // 马赛克涂鸦贴纸路径
@property (nonatomic, copy, nullable) NSString *ttsIdentifier;      // 文本朗读item的标识符
@property (nonatomic, weak, nullable) TAVMediaTTSItem *ttsItem;     // 文本朗读item
@property (atomic, strong, nullable) NSArray<TAVTrackStickerInfo *> *trackInfos;

- (instancetype)initWithStickerPath:(NSString *)stickerPath stickerType:(TAVStickerType)stickerType;
///通过TAVSticker生成一个新的文字item
- (instancetype)initWithTextSticker:(TAVSticker *)sticker;
///返回solidlayer
- (TAVStickerSolidItem *)findSolidLayer;
///返回textlayer
- (TAVStickerTextItem *)findTextLayer;
/// 根据pts时刻的追踪信息，更新贴纸的位置
- (void)updateTrackInfoAt:(CMTime)pts renderSize:(CGSize)renderSize;
/// 更新数据
/// @param lightAssetDataSourceDictionary 需要更新的数据
- (void)updateLightDataSource:(NSDictionary<NSString *,NSArray<LightDataSource *> *> *)lightAssetDataSourceDictionary;
/// light的数据描述
/// 多用于水印场景
- (NSDictionary<NSString *,NSArray<LightDataSource *> *> *)lightAssetDataSourceDictionary;
@end

NS_ASSUME_NONNULL_END
