//
//  TAVPipView.h
//  TAVMagic
//
//  Created by chavezchen on 2024/9/27.
//

#import "TAVEditableView.h"
#import <CoreMedia/CMTime.h>


NS_ASSUME_NONNULL_BEGIN
@class TAVPipView,TAVMediaPipItem,TAVEditableView;

typedef NS_ENUM(NSUInteger, TAVPipMode) {
    TAVPipModeDefault,
    TAVPipModeActive,
    TAVPipModeResign,
};

@protocol TAVPipViewDelegate <NSObject>

/**
 Ask the delegate that the pip should be hidden or not.

 @param pipView The pip-view object.
 @param currentTime The current time.
 */
- (BOOL)pipView:(TAVPipView *)pipView
   shouldHideAtTime:(CMTime)currentTime;

- (void)pipViewStartPanning:(TAVEditableView *)pipView;
- (void)pipViewChangePanning:(TAVEditableView *)pipView;
- (void)pipViewEndPanning:(TAVEditableView *)pipView;
- (void)pipViewOnDelete:(TAVPipView *)pipView;
- (void)pipViewOnClicked:(TAVPipView *)pipView;
@end



@interface TAVPipView : TAVEditableView

@property (nonatomic, strong) UIColor *borderColor;
@property (nonatomic, assign) CGFloat borderWidth;
@property (nonatomic, assign) BOOL borderHidden;
@property (nonatomic, weak) id<TAVPipViewDelegate> delegate;
@property (nonatomic, strong, readonly) UIView *borderView;
@property (nonatomic, weak, readonly) TAVMediaPipItem *pipItem;
@property (nonatomic, assign, readonly) TAVPipMode mode;
@property (nonatomic, assign) BOOL disableGestureWhenInactive; // 非活跃状态下禁止手势，默认为YES

- (instancetype)initWithPipItem:(TAVMediaPipItem *)pipItem;

- (CGRect)pipFrameInRenderRect:(CGRect)renderRect;
/**
 Update the scale rect.
 */
- (void)updateScaleRect;
/**
 Active current sticker.
 */
- (void)becomeActive;
/**
 Resign current sticker.
 */
- (void)resignActive;
/**
 Switch the mode of current pip.
 */
- (void)switchMode:(TAVPipMode)mode;

@end

NS_ASSUME_NONNULL_END
