//
//  QHPStickerContentView.h
//  TAVStickerKit
//
//  Created by Victor Tian on 2018/7/18.
//  Copyright © 2018 Tencent Inc. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "TAVStickerView.h"
#import "TAVSticker.h"


@class TAVWidgetContentView,TAVStickerContext,TAVEditor,TAVMediaPipItem,TAVPipView;
@protocol TAVWidgetContentViewDelegate <NSObject>

@optional
/// Ask the delegate that the sticker should or not be touched.
/// @param contentView The TAVWidgetContentView object.
/// @param sticker The TAVSticker object.
- (BOOL)contentView:(TAVWidgetContentView *)contentView
 shouldTouchSticker:(TAVSticker *)sticker;

- (BOOL)contentView:(TAVWidgetContentView *)contentView
 shouldTouchPipItem:(TAVMediaPipItem *)pipItem;

@end

@interface TAVWidgetContentView : UIView

@property (nonatomic, weak) TAVStickerContext *currentContext;
@property (nonatomic, weak) TAVEditor *editor;
@property (nonatomic, weak) TAVEditableView *activeView;
/// 是否不需要选中就支持手势交互，默认为NO(需要点击选中后才能执行移动缩放).
@property (nonatomic, assign) BOOL isNoFocusGestureEnabled;
/// 区域外支持移动，缩放，旋转,响应范围扩大到superView ,defaults to NO
@property (nonatomic, assign) BOOL outerResponseWidget;

- (void)removeAllStickers;
- (void)removeAllPips;

- (BOOL)shouldTouchSticker:(TAVSticker *)sticker;
- (BOOL)shouldTouchPip:(TAVMediaPipItem *)pipItem;
/// Filter valid sticker when the screen has been touched.
/// @param point The touch point.
- (NSArray <TAVSticker *> *)filterStickerWithPoint:(CGPoint)point;
- (NSArray <TAVMediaPipItem *> *)filterPipItemWithPoint:(CGPoint)point;

- (void)registerDelegate:(id<TAVWidgetContentViewDelegate>)delegate;
- (void)unregisterDelegate:(id<TAVWidgetContentViewDelegate>)delegate;

- (void)handlePanRecognizer:(UIPanGestureRecognizer *)recognizer;

@end
