#import <Foundation/Foundation.h>
#import <Photos/Photos.h>
#import <TAVMagicUIKit/TAVAlbumPickerOptions.h>
#import <TAVMagicUIKit/TAVAlbumAssetProtocol.h>

// 资源状态
typedef NS_ENUM(NSInteger, TAVAlbumAssetState) {
    TAVAlbumAssetStateUnknow,   // 资源未知
    TAVAlbumAssetStateICloud,   // 在云端
    TAVAlbumAssetStateLocal,    // 本地
    TAVAlbumAssetStateError,    // 不在本地也不在云端的情况,如用户自己删除
    TAVAlbumAssetStateLoading,  // 在云端下载到本地过程中
};

// 资源尺寸级别
typedef NS_ENUM(NSInteger, TAVAlbumAssetSizeMode) {
    TAVAlbumAssetSizeModeThumbnail,      // 缩略图
    TAVAlbumAssetSizeModeFullScreen,     // 与屏幕尺寸级别相当的中等图
    TAVAlbumAssetSizeModeFullResolution, // 全分辨率大图（原始大小的图片）
};

NS_ASSUME_NONNULL_BEGIN

@interface TAVAlbumAsset : NSObject <TAVAlbumAssetProtocol>

///@brief asset
@property (nonatomic, strong, readonly) PHAsset *asset;
///@brief 资源类型
@property (nonatomic, assign, readonly) TAVAlbumAssetType mediaType;
///@brief 唯一标识
@property (nonatomic, copy, readonly) NSString *localIdentifier;
///@brief 创建时间
@property (nonatomic, copy, readonly) NSDate *creationDate;
///@brief 最后修改时间
@property (nonatomic, copy, readonly) NSDate *modificationDate;
///@brief 分辨率宽
@property (nonatomic, assign, readonly) NSUInteger pixelWidth;
///@brief 分辨率高
@property (nonatomic, assign, readonly) NSUInteger pixelHeight;
///@brief 宽／高的比例
@property (nonatomic, assign, readonly) CGFloat aspectRatio;
/// 地理位置描述
@property (nonatomic, strong, readonly, nullable) CLLocation *location;
/// 资源状态
@property (nonatomic, assign) TAVAlbumAssetState state;
/// 资源精确时间
@property (nonatomic, assign) NSTimeInterval accuratePlayDuration;

/// 构建asset对象
/// @param asset 资源
+ (instancetype)assetWithPHAsset:(PHAsset *)asset;

/// @param sizeMode 给出大概的尺寸级别，由此加载图片。此函数调用会访问缓存。
/** @param completion  当图片获取完毕时，completion会被调用。当组件采用PhotoKit框架时，如果调用者指定的图片size比较大的话，
                      completion可能会被调用两次：第一次时，返回一张缩略图，此时complete值为NO，表示图片是缩略图；第二
                      次时，返回调用者指定尺寸的大图，此时complete值为YES。
*/
- (PHImageRequestID)loadImageWithSizeMode:(TAVAlbumAssetSizeMode)sizeMode completion:(void (^)(TAVAlbumAsset *asset, UIImage *image, BOOL complete))completion;


/// @param sizeMode 给出大概的尺寸级别，由此加载图片。
/// @param cache 是否加载缓存
/** @param completion  当图片获取完毕时，completion会被调用。当组件采用PhotoKit框架时，如果调用者指定的图片size比较大的话，
                      completion可能会被调用两次：第一次时，返回一张缩略图，此时complete值为NO，表示图片是缩略图；第二
                      次时，返回调用者指定尺寸的大图，此时complete值为YES。
*/
- (PHImageRequestID)loadImageWithSizeMode:(TAVAlbumAssetSizeMode)sizeMode
                        cache:(BOOL)cache
                   completion:(void (^)(TAVAlbumAsset *asset, UIImage *image, BOOL complete))completion;

- (PHImageRequestID)checkStorageStateWithCompletion:(void (^)(TAVAlbumAssetState state))completion;

- (void)cancleRequest:(PHImageRequestID)requestID;

- (BOOL)canSelectAssetWithMinTimeLimit:(NSTimeInterval)minTimeLimit;

@end

NS_ASSUME_NONNULL_END
