#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@class TAVAlbumAssetBottomBarCell, TAVAlbumAsset;

@protocol TAVAlbumAssetBottomBarCellDelegate <NSObject>

@optional
- (void)albumAssetBottomBarCellDidClickDelete:(TAVAlbumAssetBottomBarCell *)cell;

@end

@interface TAVAlbumAssetBottomBarCell : UICollectionViewCell

@property (nonatomic, strong, readonly) TAVAlbumAsset *albumAsset;
@property (nonatomic, weak) id<TAVAlbumAssetBottomBarCellDelegate> delegate;
@property (nonatomic, assign) BOOL dragging;
@property (nonatomic, strong, readonly) UIButton *deleteButton;
@property (nonatomic, strong, readonly) UILabel *timeLabel;

- (void)setupStateWhenReordering:(BOOL)order;
- (void)configureWithData:(nullable TAVAlbumAsset *)data imageToVideoDuration:(NSTimeInterval)imageToVideoDuration;

@end

NS_ASSUME_NONNULL_END
