#import <Foundation/Foundation.h>
#import <TAVMagicUIKit/TAVAlbumPickerOptions.h>

NS_ASSUME_NONNULL_BEGIN

@class TAVAlbumPickerOptions;

@protocol TAVAlbumAssetProtocol <NSObject>

@required

@property (nonatomic, assign, readonly) TAVAlbumAssetType albumAssetMediaType;
@property (nonatomic, copy, readonly, nullable) NSString *albumAssetIdentifier;

/// 透传的用户信息。
@property (nonatomic, strong) NSMutableDictionary *userInfo;

- (BOOL)isEqualAsset:(id)asset;
- (NSTimeInterval)durationWithPickerOptions:(TAVAlbumPickerOptions *)option;
- (BOOL)canSelectAssetWithMinTimeLimit:(NSTimeInterval)minTimeLimit;
- (BOOL)canSelectAssetWithMediaType:(TAVAlbumAssetType)mediaType;

@end

NS_ASSUME_NONNULL_END
