/*说明：
 一个列表页面中被选中的项目，可由本集合类进行统一的记录。
 （1）本集合是基于indexPath来记录被选中项目的游标位置的，indexPath要与被选中项是一一对应关系
 （2）本集合是有序的，按被选中的先后顺序记录
 */

#import <Foundation/Foundation.h>
#import <TAVMagicUIKit/TAVAlbumAssetProtocol.h>

NS_ASSUME_NONNULL_BEGIN

@class TAVAlbumPickerOptions;

@interface TAVAlbumAssetSelectionSet : NSObject

// 被选中的项目（有序的）
@property (nonatomic, readonly, copy) NSArray <TAVAlbumAssetProtocol> *selectedItems;
// 被选中的项目总数
@property (nonatomic, readonly) NSInteger count;
// 被选中的图片项目总数
@property (nonatomic, readonly) NSInteger imageCount;

- (void)clearSelection;

- (NSUInteger)indexOfSelectedItem:(NSObject <TAVAlbumAssetProtocol>*)asset;

- (NSUInteger)countOfSelectedItem:(NSObject <TAVAlbumAssetProtocol>*)asset;

- (NSUInteger)selectItem:(NSObject <TAVAlbumAssetProtocol>*)item
                  option:(TAVAlbumPickerOptions *)option;

- (void)selectItems:(NSArray <TAVAlbumAssetProtocol>*)items
             option:(TAVAlbumPickerOptions *)option;

- (NSUInteger)deselectItem:(NSObject <TAVAlbumAssetProtocol>*)asset;

- (void)deselectAllItem:(NSObject <TAVAlbumAssetProtocol>*)asset;

- (void)moveItemAtIndexPath:(NSIndexPath *)sourceIndexPath
                toIndexPath:(NSIndexPath *)targetIndexPath ;

- (void)finishStateWithOption:(TAVAlbumPickerOptions *)option
                   completion:(void (^)(BOOL finished))completion;

- (NSTimeInterval)durationWithAlbumAsset:(NSObject <TAVAlbumAssetProtocol>*)asset
                           pickerOptions:(TAVAlbumPickerOptions *)option;

- (BOOL)hasImportedAsset:(NSObject <TAVAlbumAssetProtocol>*)asset
           pickerOptions:(TAVAlbumPickerOptions *)option;

@end

NS_ASSUME_NONNULL_END
