#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@class TAVAlbumAssetSelectorBaseView, TAVAlbumAsset, TAVAlbumPickerContext;

@protocol TAVAlbumAssetSelectorViewObserver <NSObject>

@optional

- (void)albumAssetSelectorView:(TAVAlbumAssetSelectorBaseView *)selectorView
           moveItemAtIndexPath:(NSIndexPath *)sourceIndexPath
                   toIndexPath:(NSIndexPath *)targetIndexPath;

- (void)albumAssetSelectorView:(TAVAlbumAssetSelectorBaseView *)selectorView
willBeginSortingItemAtIndexPath:(NSIndexPath *)indexPath;

- (void)albumAssetSelectorView:(TAVAlbumAssetSelectorBaseView *)selectorView
  didEndSortingItemAtIndexPath:(NSIndexPath *)indexPath;

- (void)albumAssetSelectorView:(TAVAlbumAssetSelectorBaseView *)selectorView
           didDeleteAlbumAsset:(NSObject *)albumAsset indexPath:(NSIndexPath *)indexPath;

- (void)albumAssetSelectorView:(TAVAlbumAssetSelectorBaseView *)selectorView
           didSelectAlbumAsset:(TAVAlbumAsset *)albumAsset;

- (void)albumAssetSelectorViewComplete:(TAVAlbumAssetSelectorBaseView *)selectorView;

- (void)albumAssetSelectorViewRefreshVisibleCells:(TAVAlbumAssetSelectorBaseView *)selectorView;

- (void)albumAssetSelectorViewDidSpecialButtonComplete:(TAVAlbumAssetSelectorBaseView *)selectorView;

@end

@interface TAVAlbumAssetSelectorBaseView : UIView

@property (nonatomic, readonly, copy) NSArray<TAVAlbumAsset *> *albumAssets;
@property (nonatomic, readonly, strong) NSHashTable <id<TAVAlbumAssetSelectorViewObserver>> *observers;

/// Required minmum count of selected asset. Default value is 0, meaning no quantity requirement.
@property (nonatomic, assign) NSUInteger requiredItemCount;

- (instancetype)initWithFrame:(CGRect)frame context:(TAVAlbumPickerContext *)context ;

- (void)addObserver:(id <TAVAlbumAssetSelectorViewObserver>)observer;

- (void)removeObserver:(id <TAVAlbumAssetSelectorViewObserver>)observer;

- (void)addAlbumAsset:(NSObject *)albumAsset;

- (void)removeAlbumAsset:(NSObject *)albumAsset;

- (void)removeAlbumAssetWithIndex:(NSUInteger)index;

- (void)removeAlbumAsset:(NSObject *)albumAsset index:(NSUInteger)index;

- (void)showAnimatedView:(BOOL)animated;

- (void)dismissAnimatedView:(BOOL)animated;

- (void)refreshState;

- (void)refreshSpecialButtonStatus;

- (NSArray *)selectorDataSource;

- (NSArray *)selectorAlbumAssets;

- (void)updateSelectorDataSource:(NSArray *)dataSource;

@end

NS_ASSUME_NONNULL_END
