#import <Foundation/Foundation.h>
#import <TAVMagicUIKit/TAVAlbumPickerOptions.h>
#import <TAVMagicUIKit/TAVAlbumModel.h>

NS_ASSUME_NONNULL_BEGIN

@class TAVAlbumPickerContext;
@class TAVAlbumAssetCollectionViewCell;

@interface TAVAlbumAssetViewModel : NSObject

@property (nonatomic, readonly, assign) BOOL isLoadingData;
@property (nonatomic, strong) TAVAlbumModel *album;
@property (nonatomic, readonly, strong) NSError *error;
@property (nonatomic, assign) TAVAlbumAssetType assetType;
@property (nonatomic, readonly, assign) BOOL showAuthorityGuideTips;
@property (nonatomic, readonly, copy) NSArray<TAVAlbumAsset *> *assetArray;
@property (nonatomic, copy) void (^dataWillChange)(TAVAlbumAssetViewModel *viewModel);
@property (nonatomic, copy) void (^checkDataWillChange)(TAVAlbumAssetViewModel *viewModel);
@property (nonatomic, copy) void (^dataDidChange)(TAVAlbumAssetViewModel *viewModel);
@property (nonatomic, assign) CGFloat positionForImageBrowsing; //用来临时记录用户在TAVAlbumAssetViewController页面中图片的浏览位置
@property (nonatomic, assign) CGFloat positionForVideoBrowsing; //用来临时记录用户在TAVAlbumAssetViewController页面中视频的浏览位置
@property (nonatomic, assign) CGFloat positionForAllBrowsing;   //用来临时记录用户在TAVAlbumAssetViewController页面中所有的浏览位置
@property (nonatomic, assign) BOOL hasShowAlbum;

- (id)initWithContext:(TAVAlbumPickerContext *)context;
- (void)reloadData;
- (void)hiddenAuthorityGuideTips;
- (void)savePositionWithAssetType:(TAVAlbumAssetType)refreshAssetType position:(CGFloat)position;
- (NSMutableArray *)refreshIndexPathsWithVisibleCells:(NSArray<TAVAlbumAssetCollectionViewCell *> *)visibleCells;
- (BOOL)hasMaximumSelectionCountExceeded;
- (BOOL)hasMaximumSelectionPhotoCountExceeded;

@end

NS_ASSUME_NONNULL_END
