#import <Foundation/Foundation.h>
#import <TAVMagicUIKit/TAVAlbumAsset.h>

typedef void (^TAVAlbumImageDataDownloadCompletionHandler) (UIImage * _Nullable image,TAVAlbumAssetState state,NSDictionary * _Nullable info);
typedef void (^TAVAlbumAVAssetDownloadCompletionHandler)   (AVAsset * _Nullable avAsset, AVAudioMix * _Nullable audioMix, TAVAlbumAssetState state, NSDictionary * _Nullable info);

NS_ASSUME_NONNULL_BEGIN

@interface TAVAlbumDataManager : NSObject

+ (TAVAlbumDataManager *)shareInstance;

- (PHImageRequestID)loadImageForPHAsset:(PHAsset *)asset
                               sizeMode:(TAVAlbumAssetSizeMode)sizeMode
                             completion:(void (^)(UIImage *image,
                                                  BOOL complete,
                                                  NSDictionary *info))completion; // asyn

- (UIImage *)loadImageForPHAsset:(PHAsset *)asset
                        sizeMode:(TAVAlbumAssetSizeMode)sizeMode;//syn

- (PHImageRequestID)loadImageForPHAsset:(PHAsset *)asset
                                   size:(CGSize)size
                             completion:(void (^)(UIImage *image,
                                                  BOOL complete,
                                                  NSDictionary *info))completion;;

- (PHImageRequestID)loadImageForPHAsset:(PHAsset *)asset
                                   size:(CGSize)size
                                options:(PHImageRequestOptions *)options
                             completion:(void (^)(UIImage *image,
                                                  BOOL complete,
                                                  NSDictionary *info))completion;;

- (PHContentEditingInputRequestID)loadMetaDataForPHAsset:(PHAsset *)asset
                                              completion:(void (^)(NSDictionary *metaData,
                                                                   NSDictionary *info))completion;

- (PHImageRequestID)loadAVAssetForPHAsset:(PHAsset *)asset
                               completion:(void (^)(AVAsset *avAsset,
                                                    AVAudioMix *audioMix,
                                                    NSDictionary *_Nullable info))completion;

- (PHImageRequestID)loadPlayerItemForPHAsset:(PHAsset *)asset
                                  completion:(void (^)(AVPlayerItem *playerItem,
                                                       NSDictionary *_Nullable info))completion;

- (PHImageRequestID)loadExportSessionForPHAsset:(PHAsset *)asset
                                     presetName:(NSString *)presetName
                                     completion:(void (^)(AVAssetExportSession *exportSession,
                                                          NSDictionary *_Nullable info))completion;

- (void)startCachingImagesForPHAssets:(NSArray<PHAsset *> *)assets
                             sizeMode:(TAVAlbumAssetSizeMode)sizeMode;

- (void)stopCachingImagesForPHAssets:(NSArray<PHAsset *> *)assets
                            sizeMode:(TAVAlbumAssetSizeMode)sizeMode;

- (void)stopCachingImagesForAllAssets;

// 检查asset状态（本地，icloud等）
- (PHImageRequestID)checkStorageStateForPHAsset:(PHAsset *)asset
                                     completion:(void (^)(TAVAlbumAssetState state,
                                                          NSDictionary *_Nullable info))completion;

// 过滤照片数组（本地或icloud）
- (void)filterPHAssets:(NSArray<PHAsset *> *)assets
               inLocal:(BOOL)local
            completion:(void (^)(NSArray<PHAsset *> *assets))completion;

// 下载icloud资源
- (PHImageRequestID)requestImageDataForAsset:(PHAsset *)phAsset
                                     network:(BOOL)networkAccessAllowed
                                  resizeMode:(PHImageRequestOptionsResizeMode)resizeMode
                                deliveryMode:(PHImageRequestOptionsDeliveryMode)deliveryMode
                                    progress:(PHAssetImageProgressHandler _Nullable)progressHandler
                                  completion:(TAVAlbumImageDataDownloadCompletionHandler)completion ;

- (PHImageRequestID)requestAVAssetForVideo:(PHAsset *)phAsset
                                   network:(BOOL)bNetworkAccessAllowed
                              deliveryMode:(PHVideoRequestOptionsDeliveryMode)deliveryMode
                                  progress:(PHAssetVideoProgressHandler _Nullable)progressHandler
                                completion:(TAVAlbumAVAssetDownloadCompletionHandler)completion;


- (void)cancleRequest:(PHImageRequestID)requestid;

- (void)setThumbnailSizeWidth:(CGFloat)thumbnailSizeWidth;

@end

NS_ASSUME_NONNULL_END
