#import <Foundation/Foundation.h>
#import <Photos/Photos.h>
@class TAVAlbumAsset;
@class TAVAlbumDownloadAssetItem;
NS_ASSUME_NONNULL_BEGIN

typedef NS_ENUM(NSInteger, TAVAlbumDownloadAssetState) {
    TAVAlbumDownloadAssetStateInit,
    TAVAlbumDownloadAssetStateWaiting,
    TAVAlbumDownloadAssetStateDownloading,
    TAVAlbumDownloadAssetStateSuccess,
    TAVAlbumDownloadAssetStateFailed,
};

@protocol TAVAlbumDownloadAssetItemDelegate<NSObject>

- (void)albumAssetItemDownload:(TAVAlbumAsset *)asset prgress:(CGFloat)progress;
- (void)albumAssetItemDownloadComplete:(TAVAlbumDownloadAssetItem *)item;

@end

@interface TAVAlbumDownloadAssetItem : NSObject

@property (nonatomic, assign) PHImageRequestOptionsDeliveryMode imageDeliveryMode;
@property (nonatomic, assign) PHImageRequestOptionsResizeMode imageResizeMode;
@property (nonatomic, assign) PHVideoRequestOptionsDeliveryMode videoDeliveryMode;
@property (nonatomic, weak) id<TAVAlbumDownloadAssetItemDelegate> attementObject;
@property (nonatomic, strong) TAVAlbumAsset *asset;
@property (nonatomic, assign) TAVAlbumDownloadAssetState state;
@property (nonatomic, assign) PHImageRequestID requestId;
@property (nonatomic, assign) CGFloat progress;
@property (nonatomic, strong) UIImage *image;
@property (nonatomic, strong) AVAsset *avAsset;
@property (nonatomic, strong) AVAudioMix *audioMix;

- (void)updateWithDownloadAssetItem:(TAVAlbumDownloadAssetItem *)item;
- (void)resetDownloadAssetItem;
+ (TAVAlbumDownloadAssetItem *)createDownloadAssetItem:(id<TAVAlbumDownloadAssetItemDelegate>)attementObject asset:(TAVAlbumAsset*)aset;

@end

NS_ASSUME_NONNULL_END
