#import <Foundation/Foundation.h>
#import <TAVMagicUIKit/TAVAlbumModel.h>

NS_ASSUME_NONNULL_BEGIN

@class TAVAlbumPickerContext;

@interface TAVAlbumListViewModel : NSObject

@property (nonatomic, readonly, copy) NSArray<TAVAlbumModel *> *albums;
@property (nonatomic, readonly, strong) NSError *error;
@property (nonatomic, copy) void (^dataWillChange)(TAVAlbumListViewModel *viewModel);
@property (nonatomic, copy) void (^__nullable dataDidChange)(TAVAlbumListViewModel *viewModel);
@property (nonatomic, copy) void (^dataDidUpdate)(TAVAlbumListViewModel *viewModel);

- (id)initWithContext:(TAVAlbumPickerContext *)context;
- (void)reloadData;
- (BOOL)canDisplayAlbumsList;

@end

NS_ASSUME_NONNULL_END
