#import <Foundation/Foundation.h>
#import <Photos/Photos.h>
#import <TAVMagicUIKit/TAVAlbumAsset.h>

NS_ASSUME_NONNULL_BEGIN

@interface TAVAlbumModel : NSObject

@property (nonatomic, strong, readonly) PHAssetCollection *phAssetCollection;
@property (nonatomic, copy, readonly) NSString *identifier;
@property (nonatomic, copy, readonly) NSString *name;
@property (nonatomic, copy, readonly) NSString *title;

@property (nonatomic, assign) NSInteger numberOfAssets;
@property (nonatomic, strong, nullable) TAVAlbumAsset *latestAsset;

/// 本相册是否为“相机胶卷”相册
@property (nonatomic, assign, readonly) BOOL isCameraAlbum;

/// 是否是系统相册
@property (nonatomic, assign) BOOL isSystemAlbum;

+ (instancetype)albumWithPHAssetCollection:(PHAssetCollection *)assetCollection;

- (BOOL)isAlbum:(TAVAlbumType)albumType;

- (void)loadPostImageWithCompletion:(void (^)(TAVAlbumModel *album, UIImage *image))completion;

@end

NS_ASSUME_NONNULL_END
