#import <Foundation/Foundation.h>
#import <Photos/Photos.h>

NS_ASSUME_NONNULL_BEGIN

extern NSInteger const TAVAlbumPickerOptionsMaximumSelectionDefaultCount;
extern NSInteger const TAVAlbumPickerOptionsMaximumSelectionPhotoDefaultCount;

typedef NS_ENUM(NSInteger, TAVAlbumAssetType) {
    TAVAlbumAssetTypeUnknown = 0,
    TAVAlbumAssetTypeImage   = 1,
    TAVAlbumAssetTypeVideo   = 2,
    TAVAlbumAssetTypeAll     = 3  // 以上
};

typedef NS_ENUM(NSInteger, TAVAlbumType) {
    TAVAlbumTypeInvalid, //无效值
    TAVAlbumTypeCamera,  //“相机胶卷”相册
    TAVAlbumTypeVideo,   //“视频”相册
};

typedef NS_ENUM(NSInteger, TAVAlbumAssetOperationType) {
    TAVAlbumAssetOperationTypeUnknown,
    TAVAlbumAssetOperationTypeAdd,
    TAVAlbumAssetOperationTypeDelete,
};

typedef NS_ENUM(NSInteger, TAVAlbumPattern) {
    TAVAlbumPatternDefault,            //普通默认模式
    TAVAlbumPatternFastSingle,         //快速单选模式，只能选取一个资源，且选取后立即返回资源
    TAVAlbumPatternRepeatedSelection,  //重复选取模式，每个资源可以重复添加
};

@interface TAVAlbumPickerCustomViewOptions : NSObject

///*@brief 自定义相册资源页，请继承TAVAlbumAssetViewController，可自定义导航栏、资源列表、底部资源选择器布局等
@property (nonatomic, strong) Class albumAssetViewControllerClass;

///*@brief 自定义相册资源导航控件，请继承TAVAlbumAssetNavigationView
@property (nonatomic, strong) Class albumAssetNavigationViewClass;

///*@brief 自定义相册资源导航控件，请继承TAVAlbumAssetTypeSelectorView
@property (nonatomic, strong) Class albumAssetTypeSelectorViewClass;

///*@brief 自定义相册资源选择器，请继承TAVAlbumAssetSelectorBaseView或者TAVAlbumAssetSelectorView
@property (nonatomic, strong) Class albumAssetSelectorViewClass;

///*@brief 自定义相册资源列表，请继承TAVAlbumAssetListController
@property (nonatomic, strong) Class albumAssetListControllerClass;

///*@brief 自定义相册资源列表Cell控件，请继承TAVAlbumAssetCollectionViewCell
@property (nonatomic, strong) Class albumAssetCollectionViewCellClass;

///*@brief 自定义相册列表Cell控件，请继承TAVAlbumListTableViewCell
@property (nonatomic, strong) Class albumListTableViewCellClass;

///*@brief 自定义相册选择器Cell控件，请继承TAVAlbumAssetBottomBarCell
@property (nonatomic, strong) Class albumAssetBottomBarCellClass;

///*@brief 自定义相册预览页，请继承TAVAlbumPreviewViewController
@property (nonatomic, strong) Class albumPreviewViewControlleClass;

///*@brief 自定义相册预览导航控件，请继承TAVAlbumPreviewNavigationView
@property (nonatomic, strong) Class albumPreviewNavigationViewClass;

///*@brief 自定义相册预览列表图片Cell控件，请继承TAVAlbumPreviewImageCell
@property (nonatomic, strong) Class albumPreviewImageCellClass;

///*@brief 自定义相册预览列表视频Cell控件，请继承TAVAlbumPreviewVideoCell
@property (nonatomic, strong) Class albumPreviewVideoCellClass;

///*@brief 自定义相册预览列表视频控制条，请继承TAVAlbumPreviewPlayerControlPanel
@property (nonatomic, strong) Class albumPreviewPlayerControlPanelClass;

///*@brief 自定义相册权限提示栏，请继承TAVAlbumAssetCollectionViewHeader
@property (nonatomic, strong) Class albumAssetCollectionViewHeaderClass;

///*@brief 自定义相册资源选择管理类，请继承TAVAlbumAssetSelectionSet
@property (nonatomic, strong) Class albumAssetSelectionSetClass;

@end

@interface TAVAlbumPickerOptions : NSObject

#pragma mark - 相册展示模式

@property (nonatomic, assign) TAVAlbumPattern pattern;

#pragma mark - 过滤媒体类型

/// @brief 过滤媒体类型
/// 默认 TAVAlbumAssetTypeAll
/// TAVAlbumAssetTypeImage  只显示图片类型，并隐藏类型选择栏
/// TAVAlbumAssetTypeVideo   只显示视频类型，并隐藏类型选择栏
/// TAVAlbumAssetTypeAll        视频与图片都显示，并显示类型选择栏
@property (nonatomic, assign) TAVAlbumAssetType mediaType;

#pragma mark - 选取数目上限

/// @brief 选取素材的数目上限。
/// 一旦用户选中素材的总数达到此值，之后无论选取任何素材，
/// 都将产生弹窗提示，并且选取无效。
/// 注意：只有此值大于0时才有效，等于0时表示无限选择（默认为0）
@property (nonatomic, assign) NSUInteger maximumSelectionCount;

/// @brief 选取照片的数目上限。
/// 一旦用户选中照片的总数达到此值，之后无论选取任何照片，
/// 都将产生弹窗提示，并且选取无效。注意：只有此值大于0时才有效，
/// 等于0时表示无限选择（默认为0）
@property (nonatomic, assign) NSUInteger maximumSelectionPhotoCount;

///*@brief 支持配置素材的最小段数，选取素材不达到数量的时候隐藏,默认值为1
@property (nonatomic, assign) NSUInteger minimumSelectionCount;

///*@brief 支持配置素材的最小秒数（模版会用到），
///选取素材不达到秒数的时候，下一步按钮隐藏
@property (nonatomic, assign) NSTimeInterval minimumDuration;

///*@brief 时间过滤条件,过滤掉时长小于minTimeLimit的视频,（默认为0.0）
@property (nonatomic, assign) NSTimeInterval minTimeLimit;

///*@brief 已导入的资源标记数组
/// 传入已导入的相册资源的localIdentifier,相册资源列表页即可显示已导入的标识
@property (nonatomic, copy) NSArray<NSString *> *importedArray;

///*@brief 图片转视频时间，默认3.0秒
@property (nonatomic, assign) NSTimeInterval imageToVideoDuration;

///*@brief 选图器展示栏高度
@property (nonatomic, assign) CGFloat assetSelectorViewHighet;

///*@brief 设置iCloud下载时检查最小磁盘空间阈值，当小于此阈值时，出磁盘空间不足提示。默认值：500 * 1024 *1024 即 500MB
@property (nonatomic, assign) int64_t minimumICloudDownloadFreeDiskSize;

///*@brief 设置iCloud图片下载传输模式，默认PHImageRequestOptionsDeliveryModeHighQualityFormat
@property (nonatomic, assign) PHImageRequestOptionsDeliveryMode iCloudImageDeliveryMode;

///*@brief 设置iCloud图片下载大小模式，默认PHImageRequestOptionsResizeModeNone
@property (nonatomic, assign) PHImageRequestOptionsResizeMode iCloudImageResizeMode;

///*@brief 设置iCloud视频下载传输模式，默认PHVideoRequestOptionsDeliveryModeHighQualityFormat
@property (nonatomic, assign) PHVideoRequestOptionsDeliveryMode iCloudVideoDeliveryMode;

///*@brief 相册完成选取资源后自动退出界面
/// YES - 自动退出NO - 不自动退出
/// 默认YES
@property (nonatomic, assign) BOOL autoDismiss;

///*@brief 选图器展示栏提示文案
/// 默认文案："片段总时长"
@property (nonatomic, copy) NSString *assetSelectorViewTips;

///*@brief 选图器展示栏第二行小字提示文案
/// 默认文案："长按镜头可排序"
@property (nonatomic, copy) NSString *assetSelectorViewSubTips;

///*@brief 选图器主题色
/// 没设置的话使用默认：黄色
@property (nonatomic, strong) UIColor *themeColor;

///*@brief 外部调用相册自定义数据模型
///内部自定义页面可通过此数据进行构建解析，例如自定义模板选图器，
///可将模板数据传递至相册，再通过外部自定义的模板选图器解析构建界面
@property (nonatomic, strong) id customData;

#pragma mark - 自定义界面类
@property (nonatomic, strong) TAVAlbumPickerCustomViewOptions *customViewOptions;

#pragma mark - 创建

///*@brief 创建一个默认配置
+ (instancetype)defaultOptions;

@end

NS_ASSUME_NONNULL_END
