//
//  TAVContainerProtocols.h
//  Pods
//
//  Created by Robin on 2024/9/5.
//

#ifndef TAVContainerProtocols_h
#define TAVContainerProtocols_h

#import <UIKit/UIKit.h>
#import <TAVMagicUIKit/TAVContainerConstants.h>

@class TAVDraftComponent;

@protocol ITAVContainer <NSObject>
- (void)switchToLayout:(TAVLayoutName)layoutName;
- (void)closeContainer;
- (void)closeContainerWithCompletion:(void (^)(void))completion;
@end

@protocol ITAVProcessor
/// life cycle
//- (instancetype)initWithContext:(id)context;
- (void)setupProcessor:(id)context;
- (void)processorDidLoad;
- (void)processorWillAppear:(BOOL)animated;
- (void)processorDidAppear:(BOOL)animated;
- (void)processorWillDisappear:(BOOL)animated;
- (void)processorDidDisappear:(BOOL)animated;
- (void)processorWillLayoutSubviews;
- (void)processorDidLayoutSubviews;
/// draft
- (void)handleDraftRemovedComponent:(TAVDraftComponent *)component;
- (void)handleDraftAddedComponent:(TAVDraftComponent *)component;
- (void)handleDraftUpdatedComponent:(TAVDraftComponent *)newComponent
                       oldComponent:(TAVDraftComponent *)oldComponent;
- (void)handleDraftComponentsCompleted;
@end

@protocol ITAVContext;
@protocol ITAVLayoutManager <NSObject>
- (instancetype)initWithContext:(id<ITAVContext>)context containerView:(UIView *)containerView;
- (void)switchToLayout:(TAVLayoutName)layoutName;
@end

@protocol ITAVContext <NSObject>
@property (nonatomic, weak) UIViewController<ITAVContainer> *container;
@property (nonatomic, copy) TAVLayoutName layoutName;
@end

#endif /* TAVContainerProtocols_h */
