//
//  TAVEditConstants.h
//  Pods
//
//  Created by Robin on 2024/9/6.
//
#import <CoreMedia/CoreMedia.h>
#ifndef TAVVideoEditConstants_h
#define TAVVideoEditConstants_h

typedef NS_ENUM(NSUInteger, TAVEditState) {
    TAVEditStateMain,
    TAVEditStateVideo,
    TAVEditStateText,
    TAVEditStateBGM,
    TAVEditStateVoiceover,
    TAVEditStateOverlay,
};

typedef NS_ENUM(NSUInteger, TAVTrackType) {
    TAVTrackTypeText,
    TAVTrackTypeOverlay,
    TAVTrackTypeVideo,
    TAVTrackTypeBgm,
    TAVTrackTypeVoiceOver,
};

typedef NS_ENUM(NSUInteger, TAVSelectableTrackType) {
    TAVSelectableTrackTypeText,
    TAVSelectableTrackTypeOverlay,
    TAVSelectableTrackTypeVideo,
    TAVSelectableTrackTypeBgm,
    TAVSelectableTrackTypeVoiceOver,
    TAVSelectableTrackTypeAll,
    TAVSelectableTrackTypeNone,
};

typedef NSUInteger TAVMediaRate;
extern const TAVMediaRate TAVMediaRate100;

typedef NS_ENUM(NSUInteger, TAVTrackHeight) {
    TAVTrackHeightVideo = 45,
    TAVTrackHeightText = 30,
    TAVTrackHeightBgm = 30,
    TAVTrackHeightVoiceOver = 30,
    TAVTrackHeightOverlay = 30
};

#define kEditorMinimumTimeInterval (2.0 / 600)

#define kTAVDefaultTimeScale 600

#endif /* TAVVideoEditConstants_h */
