//
//  TAVEditorPreViewContext.h
//  TAVMagicUIKit
//
//  Created by v_zwtzzhou on 2024/9/23.
//

#import <Foundation/Foundation.h>
#import <TAVMagicUIKit/TAVContainerProtocols.h>
#import <TAVMagicUIKit/TAVEditorPreviewService.h>
#import <TAVMagicUIKit/ITAVMaterialProvider.h>
#import <TAVMagicUIKit/ITAVEditInterceptor.h>

NS_ASSUME_NONNULL_BEGIN

@class TAVEditorPreviewController, TAVEditor;

@interface TAVEditorPreViewContext : NSObject<ITAVContext>

@property (nonatomic, strong) TAVEditor *editor;

@property (nonatomic, weak) TAVEditorPreviewController *container;

@property (nonatomic, weak) id<TAVEditorPreviewService> editPreview;

@property (nonatomic, strong) NSMutableArray *voiceoverIds; // 记录录音id，用于区分bgm和录音

@property (nonatomic, strong) id<ITAVMaterialProvider> materialProvider;
@property (nonatomic, strong) id<ITAVEditInterceptor> editInterceptor;

@property (nonatomic, assign) NSTimeInterval minimumEditableDuration;

@property (nonatomic, assign) NSTimeInterval maximumEditableDuration;

// provider

@end

NS_ASSUME_NONNULL_END
