//
//  TAVFoundation.h
//  Pods
//
//  Created by chavezchen on 2024/1/3.
//

#import <Foundation/Foundation.h>
#import <AVFoundation/AVFoundation.h>

#ifndef TAVFoundation_h
#define TAVFoundation_h

#define tav_string_concat(A, B) tav_string_concat_(A, B)
#define tav_string_concat_(A, B) A ## B

#define SESYNTH_DYNAMIC_PROPERTY_OBJECT(_getter_, _setter_, _association_, _type_) \
- (void)_setter_ : (_type_)object { \
    [self willChangeValueForKey:@#_getter_]; \
    objc_setAssociatedObject(self, _cmd, object, OBJC_ASSOCIATION_ ## _association_); \
    [self didChangeValueForKey:@#_getter_]; \
} \
- (_type_)_getter_ { \
    return objc_getAssociatedObject(self, @selector(_setter_:)); \
}

#if __has_feature(objc_arc)
#define tav_weakify(pointer) \
__weak __typeof__(pointer) tav_string_concat(pointer, _weak_) = (pointer)

#define tav_strongify(pointer) \
_Pragma("clang diagnostic push") \
_Pragma("clang diagnostic ignored \"-Wshadow\"") \
__strong __typeof__(pointer) pointer = tav_string_concat(pointer, _weak_) \
_Pragma("clang diagnostic pop")

#endif

@interface TAVFoundation : NSObject

+ (NSString *)systemVersion;

+ (CGFloat)systemVersionValue;

+ (NSString *)deviceName;

+ (NSString *)deviceModel;

/// app剩余可用内存
+ (double)availableMemory;

/// app当前使用内存
+ (double)footprintMemory;

+ (BOOL)isiPad;
/// 是否是 Pro Max 大屏机
+ (BOOL)isMaxScreen;

+ (BOOL)isLandscape;

+ (void)createDirectoryAtPath:(NSString *)path;

+ (BOOL)isDirectoryExistAndNotEmpty:(NSString *)path;

+ (void)add2xToPngFileName:(NSString *)filePath;

+ (BOOL)isFileExistsAndFileValid:(NSString *)filePath;

+ (BOOL)isFileExists:(NSString *)path;

+ (CGSize)getSizeWithTransform:(CGAffineTransform)transform size:(CGSize)inputSize;

+ (NSString *)daytimeStringFromDate:(NSDate *)date;

+ (AVAsset *)videoAssetFromPath:(NSString *)videoPath;

+ (CGSize)videoSizeFromPath:(NSString *)videoPath;

+ (CGFloat)videoBitRateFromPath:(NSString *)videoPath;

+ (Float64)videoDurationFromPath:(NSString *)videoPath;

+ (int64_t)fileSizeWithPath:(NSString *)filePath;

+ (CGSize)imageSizeFromPath:(NSString *)filePath;

+ (CGFloat)imageScaleFromPath:(NSString *)filePath;

/// 当前时区时间
+ (NSDate *)currentDate;

/// 获取星期几
+ (NSString *)weekDayWithDate:(NSDate *)date;

/// 获取年份
+ (NSInteger)yearWithDate:(NSDate *)date;

/// 获取年-月-日-时
+ (NSString *)simpleContentFromDate:(NSDate *)date;

@end

BOOL TAVIsNightModeTheme(void);

BOOL TAVIsCareModeTheme(void);


#endif /* TAVFoundation_h */
