//
//  TEUIProperty.h
//  TEBeautyKit
//
//  Created by tao yue on 2024/1/8.
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSUInteger, TEUIState) {
    TEUIState_INIT,
    TEUIState_IN_USE,
    TEUIState_CHECKED_AND_IN_USE,
};

typedef NS_ENUM(NSUInteger, TECategory) {
    TECategory_BEAUTY,              //美颜、美型、美体
    TECategory_LUT,                 //滤镜
    TECategory_MAKEUP,              //美妆（风格整装）
    TECategory_MOTION,              //动效
    TECategory_SEGMENTATION,        //分割
    TECategory_TEMPLATE,            //美颜模板
    TECategory_LIGHTMAKEUP,         //轻美妆
    TECategory_BEAUTYMAKEUP,        //单点美妆
};

@interface ExtraInfo : NSObject
@property (nonatomic, copy) NSString *segType;
@property (nonatomic, copy) NSString *makeupLutStrength;
@property (nonatomic, copy) NSString *mergeWithCurrentMotion;
@property (nonatomic, copy) NSString *bgType;
@property (nonatomic, copy) NSString *bgPath;
@property (nonatomic, copy) NSString *keyColor;

- (instancetype)initWithDict:(NSDictionary *)dict;

@end

@interface TESDKParam : NSObject
@property (nonatomic, copy) NSString *effectName;
@property (nonatomic, assign) int effectValue;
@property (nonatomic, copy) NSString *abilityType;
@property (nonatomic, copy) NSString *resourcePath;
@property (nonatomic, assign) BOOL numericalType;//是否是数值型
@property (nonatomic, strong) ExtraInfo *extraInfo;
@property (nonatomic, strong) NSDictionary *extraInfoDic;

- (instancetype)initWithDict:(NSDictionary *)dict;
- (NSDictionary *)toDictionary;

@end

@interface TEUIProperty : NSObject
@property (nonatomic, copy) NSString *displayName;
@property (nonatomic, copy) NSString *displayNameEn;
@property (nonatomic, copy) NSString *icon;
@property (nonatomic, copy) NSString *downloadPath;
@property (nonatomic, copy) NSString *resourceUri;
@property (nonatomic, assign) TEUIState uiState;
@property (nonatomic, strong) NSMutableArray<TEUIProperty *> *propertyList;
@property (nonatomic, strong) TESDKParam *sdkParam;
@property (nonatomic, assign) TECategory teCategory;
@property (nonatomic, copy) NSString *uiCategory;
@property (nonatomic, strong) NSMutableArray<TESDKParam *> *paramList;
@property (nonatomic, assign) BOOL isSelected;
@property (nonatomic, copy) NSString *abilityType;
@property (nonatomic, copy) NSString *label;
@property (nonatomic, copy) NSString *labelEn;
@property (nonatomic, copy) NSString *Id;
@property (nonatomic, copy) NSString *parentId;
@property (nonatomic, assign) BOOL isShowGridLayout;
@property (nonatomic, assign) BOOL hasSubTitle;  //二级标题
@property (nonatomic, assign) BOOL verticalLayout;  //竖向滚动

- (instancetype)initWithDict:(NSDictionary *)dict;
- (NSDictionary *)toDictionary;

@end
