//
//  TEBeautyProcess.m
//  TEBeautyKit
//
//  Created by wwk on 2025/9/9.
//

#import "TEBeautyProcess.h"
#import "TEUtils.h"
#import "TEUIDefine.h"
#import <XMagic/XmagicConstant.h>
#import "TEDownloader.h"
#import "TEUIConfig.h"

// 视频长度限制(ms)
static const int MAX_SEG_VIDEO_DURATION = 200 * 1000;

@interface TEBeautyProcess()
@property (nonatomic, assign) int segmentationBgType;                  // 背景分割类型
@property (nonatomic, assign) int segmentationType;                    // 分割算法类型
@property (nonatomic, copy) NSString* segmentationResPath;            // 分割资源路径
@property (nonatomic, assign) BOOL lightMakeupUsed;                    // 轻美妆使用状态
@property (nonatomic, copy) NSString* mergeCurMotion;                  // 当前合并动画路径
@property (nonatomic, strong) NSNumber* timeOffset;                    // 时间偏移量

@property (nonatomic, strong) NSMutableArray<TEUIProperty *> *defaultBeautyList;    // 默认美颜配置列表
@property (nonatomic, strong) NSMutableArray<NSString *> *beautyMakeupEffectNames; // 单点美妆效果名称列表
@property (nonatomic, strong) NSArray *allBundleNames;              //资源bundle
@property (nonatomic, strong) TEUIProperty *currentProperty;        //当前选中的效果
@property (nonatomic, copy) NSString *custom_background_imagePath;      //自定义背景图片路径
@property (nonatomic, copy) NSString *green_background_v2_background_imagePath;     //绿幕抠图v2图片路径
@property (nonatomic, copy) NSString *green_background_imagePath;       //绿幕抠图v1图片路径
@property (nonatomic, strong) NSMutableDictionary *extraInfo;   //绿幕参数
@property (nonatomic, strong) NSMutableArray *greenBackgroundV2Params; //绿幕v2效果参数

@end

@implementation TEBeautyProcess

#pragma mark - public
- (void)updateBeautyEffect:(TEUIProperty *)teUIProperty {
    _currentProperty = teUIProperty;
    if (teUIProperty.teCategory == TECategory_BEAUTY ||
        teUIProperty.teCategory == TECategory_BEAUTYMAKEUP) {
        [self clearBeautyTemplate];
        if (self.lightMakeupUsed && [self.beautyMakeupEffectNames containsObject:teUIProperty.sdkParam.effectName]) {
            [self clearLightMakeup];
            [self clearLastBeautyUi:TECategory_LIGHTMAKEUP];
            self.lightMakeupUsed = NO;
        }
        BOOL save = YES;
        if (teUIProperty.sdkParam == nil) {
            save = NO;//关闭美颜不用保存
            NSMutableArray<TESDKParam *> *sdkParamList = [_teBeautyKit getInUseSDKParamList];
            for (TESDKParam *sdkParam in sdkParamList) {
                if ([TEUtils isBeauty:sdkParam.effectName] &&
                    [teUIProperty.abilityType isEqualToString:sdkParam.abilityType]) {
                    sdkParam.effectValue = 0;
                    [_teBeautyKit setEffect:sdkParam];
                    [_teBeautyKit deleteEffectParam:sdkParam];
                }
            }
            teUIProperty.uiState = 2;
            if ([self.delegate respondsToSelector:@selector(beautyCollectionReloadData)]) {
                [self.delegate beautyCollectionReloadData];
            }
        }
        //如果是单点美妆选择了关闭，要隐藏slider
        if ([self.tePanelDataProvider.beautyMakeupNoneGroup containsObject:teUIProperty.sdkParam.effectName] &&
            teUIProperty.sdkParam.resourcePath.length == 0 &&
            teUIProperty.sdkParam.effectValue == 0) {
            if ([self.delegate respondsToSelector:@selector(teSliderIsHidden)]) {
                [self.delegate teSliderIsHidden];
            }
        }
        [self setBeauty:teUIProperty.sdkParam.effectName effectValue:teUIProperty.sdkParam.effectValue resourcePath:teUIProperty.sdkParam.resourcePath extraInfo:nil abilityType:teUIProperty.abilityType save:save];
    } else if (teUIProperty.teCategory == TECategory_LUT) {
        [self clearBeautyTemplate];
        if (self.lightMakeupUsed) {
            [self clearLightMakeup];
            [self clearLastBeautyUi:TECategory_LIGHTMAKEUP];
            self.lightMakeupUsed = NO;
        }
        NSString *path = [self searchLocalResourceName:teUIProperty.resourceUri dirPath:teUIProperty.downloadPath];
        if (path || !teUIProperty.resourceUri) {
            [self setBeauty:EFFECT_LUT effectValue:teUIProperty.sdkParam.effectValue resourcePath:path extraInfo:nil abilityType:teUIProperty.abilityType save:YES];
        } else {
            [self downloadRes:EFFECT_LUT teUIProperty:teUIProperty];
        }
    } else if (teUIProperty.teCategory == TECategory_LIGHTMAKEUP) {
        if (teUIProperty.resourceUri == nil) {
            self.lightMakeupUsed = NO;
        } else {
            self.lightMakeupUsed = YES;
        }
        [self clearLastBeautyUi:TECategory_BEAUTYMAKEUP];
        [self clearLastBeautyUi:TECategory_LUT];
        NSString *path = [self searchLocalResourceName:teUIProperty.resourceUri dirPath:teUIProperty.downloadPath];
        if (path || !teUIProperty.resourceUri) {
            NSString *makeupLutStrength = teUIProperty.sdkParam.extraInfo.makeupLutStrength;
            NSMutableDictionary *extraInfo = [NSMutableDictionary dictionary];
            extraInfo[@"makeupLutStrength"] = makeupLutStrength;
            [self setBeauty:EFFECT_LIGHT_MAKEUP effectValue:teUIProperty.sdkParam.effectValue resourcePath:path extraInfo:extraInfo abilityType:teUIProperty.abilityType save:YES];
        } else {
            [self downloadRes:EFFECT_LIGHT_MAKEUP teUIProperty:teUIProperty];
        }
    } else if (teUIProperty.teCategory == TECategory_MOTION) {
        NSString *path = [self searchLocalResourceName:teUIProperty.resourceUri dirPath:teUIProperty.downloadPath];
        if (path || !teUIProperty.resourceUri) {
            NSMutableDictionary *extraInfo = [NSMutableDictionary dictionary];
            extraInfo[@"mergeWithCurrentMotion"] = teUIProperty.sdkParam.extraInfo.mergeWithCurrentMotion;
            [self setBeauty:EFFECT_MOTION effectValue:teUIProperty.sdkParam.effectValue resourcePath:path extraInfo:extraInfo abilityType:teUIProperty.abilityType save:YES];
        } else {
            [self downloadRes:EFFECT_MOTION teUIProperty:teUIProperty];
        }
    } else if (teUIProperty.teCategory == TECategory_MAKEUP) {
        NSString *path = [self searchLocalResourceName:teUIProperty.resourceUri dirPath:teUIProperty.downloadPath];
        if (path || !teUIProperty.resourceUri) {
            NSString *makeupLutStrength = teUIProperty.sdkParam.extraInfo.makeupLutStrength;
            NSMutableDictionary *extraInfo = [NSMutableDictionary dictionary];
            extraInfo[@"makeupLutStrength"] = makeupLutStrength;
            extraInfo[@"mergeWithCurrentMotion"] = teUIProperty.sdkParam.extraInfo.mergeWithCurrentMotion;
            [self setBeauty:EFFECT_MAKEUP effectValue:teUIProperty.sdkParam.effectValue resourcePath:path extraInfo:extraInfo abilityType:teUIProperty.abilityType save:YES];
        } else {
            [self downloadRes:EFFECT_MAKEUP teUIProperty:teUIProperty];
        }
    } else if (teUIProperty.teCategory == TECategory_SEGMENTATION) {
        NSString *path = [self searchLocalResourceName:teUIProperty.resourceUri dirPath:teUIProperty.downloadPath];
        if (path || !teUIProperty.resourceUri) {
            [self setSegmentation:path teUIProperty:teUIProperty];
        } else {
            [self downloadRes:EFFECT_SEGMENTATION teUIProperty:teUIProperty];
        }
    } else if (teUIProperty.teCategory == TECategory_TEMPLATE) {
        //选择美颜模板，先清空旧效果，再设置模板效果
        NSMutableArray<TESDKParam *> *sdkParamList = [_teBeautyKit getInUseSDKParamList];
        for (TESDKParam *sdkParam in sdkParamList) {
            if ([TEUtils isBeauty:sdkParam.effectName]) {
                sdkParam.effectValue = 0;
                [_teBeautyKit setEffect:sdkParam];
                [_teBeautyKit deleteEffectParam:sdkParam];
            }
        }
        [self setBeauty:EFFECT_LUT effectValue:0 resourcePath:nil extraInfo:nil abilityType:nil save:NO];
        for (TESDKParam *param in teUIProperty.paramList) {
            if ([TEUtils isBeauty:param.effectName]) {
                [self setBeauty:param.effectName effectValue:param.effectValue resourcePath:param.resourcePath extraInfo:nil abilityType:TEUI_BEAUTY save:YES];
            }
            if ([param.effectName isEqualToString:EFFECT_LUT]) {
                [self setBeauty:EFFECT_LUT effectValue:param.effectValue resourcePath:param.resourcePath extraInfo:nil abilityType:TEUI_LUT save:YES];
            }
        }
        //同步效果
        [self syncEffectParamList:teUIProperty.paramList];
        if (teUIProperty.paramList.count) {
            [self saveBeautyTemplate:teUIProperty];
        } else {
            [self clearBeautyTemplate];
        }
    }
}

- (void)setDefaultBeauty {
    [self updateBeautyEffect:[self searchInUseProperty:self.currentUIProperty.propertyList]];
}

- (void)clearBeauty:(NSMutableArray<TESDKParam *> *)sdkParams {
    for (TESDKParam *param in sdkParams) {
        [self setBeauty:param.effectName effectValue:0 resourcePath:param.resourcePath extraInfo:nil abilityType:param.abilityType save:NO];
    }
    [_teBeautyKit clearEffectParam];
}

- (void)resetBeauty {
    [self setBeauty:EFFECT_LIGHT_MAKEUP effectValue:0 resourcePath:nil extraInfo:nil abilityType:nil save:YES];
    [self setBeauty:EFFECT_MOTION effectValue:0 resourcePath:nil extraInfo:nil abilityType:nil save:YES];
    [self setBeauty:EFFECT_SEGMENTATION effectValue:0 resourcePath:nil extraInfo:nil abilityType:nil save:YES];
    [self setBeauty:EFFECT_LUT effectValue:0 resourcePath:nil extraInfo:nil abilityType:nil save:YES];
    [self setBeauty:EFFECT_MAKEUP effectValue:0 resourcePath:nil extraInfo:nil abilityType:nil save:YES];
}

- (void)setBeauty:(NSString * _Nullable)effectName
      effectValue:(int)effectValue
     resourcePath:(NSString * _Nullable)resourcePath
        extraInfo:(NSDictionary * _Nullable)extraInfo
      abilityType:(NSString * _Nullable)abilityType
             save:(BOOL)save {
    float multiple = 1;
    if (self.enhancedMode && ([TEUtils isBeauty:effectName])) {
        id value = [self.tePanelDataProvider.enhancedMultipleDictionary valueForKey:effectName];
        if (value != nil) {
            multiple = [value floatValue];
        } else {
            multiple = 1.2;
        }
    }
    [self.teBeautyKit.xmagicApi setEffect:effectName effectValue:effectValue * multiple resourcePath:resourcePath extraInfo:extraInfo];
    //保存美颜数据
    if (save) {
        TESDKParam *param = [[TESDKParam alloc] init];
        param.effectName = effectName;
        param.effectValue = effectValue;
        param.resourcePath = [self convertPathToCustomPrefix:resourcePath];
        param.extraInfoDic = extraInfo;
        param.abilityType = abilityType;
        if ([effectName isEqualToString:EFFECT_LUT] ||
            [effectName isEqualToString:EFFECT_LIGHT_MAKEUP] ||
            [effectName isEqualToString:EFFECT_MOTION] ||
            [effectName isEqualToString:EFFECT_MAKEUP] ||
            [effectName isEqualToString:EFFECT_SEGMENTATION]) {
            if (resourcePath) {
                [_teBeautyKit saveEffectParam:param];
            } else {
                //resourcePath为空说明是关闭，删除缓存
                [_teBeautyKit deleteEffectParam:param];
            }
        } else {
            //互斥检查
            NSArray *exclusionArray = [self searchMutualExclusion:effectName];
            [_teBeautyKit.usedSDKParam enumerateObjectsWithOptions:NSEnumerationReverse usingBlock:^(TESDKParam * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
                if ([exclusionArray containsObject:obj.effectName]) {
                    [_teBeautyKit deleteEffectParam:obj];
                }
            }];
            [_teBeautyKit saveEffectParam:param];
        }
    }
    if ([self.delegate respondsToSelector:@selector(setEffect)]) {
        [self.delegate setEffect];
    }
}

#pragma mark - private
- (void)setSegmentation:(NSString *)path teUIProperty:(TEUIProperty *)teUIProperty {
    _mergeCurMotion = teUIProperty.sdkParam.extraInfo.mergeWithCurrentMotion;
    if ([teUIProperty.sdkParam.extraInfo.segType isEqualToString:TEUI_CUSTOM_BACKGROUND]) {
        _segmentationType = 0;
        _segmentationResPath = path;
        if ([self.delegate respondsToSelector:@selector(teOpenImagePicker)]) {
            [self.delegate teOpenImagePicker];
        }
    } else if ([teUIProperty.sdkParam.extraInfo.segType isEqualToString:TEUI_GREEN_BACKGROUND] || [teUIProperty.sdkParam.extraInfo.segType isEqualToString:TEUI_GREEN_BACKGROUND_V2]) {
        _segmentationType = 1;
        _segmentationResPath = path;
        if ([self.delegate respondsToSelector:@selector(teGreenscreenAlert)]) {
            [self.delegate teGreenscreenAlert];
        }
    } else if ([teUIProperty.uiCategory isEqualToString:TEUI_GATEGORY_GREEN_BACKGROUND_V2_ITEM_IMPORT_IMAGE]) {
        if ([self.delegate respondsToSelector:@selector(teOpenImagePicker)]) {
            [self.delegate teOpenImagePicker];
        }
    } else {
        NSMutableDictionary *extraInfo = [NSMutableDictionary dictionary];
        extraInfo[@"mergeWithCurrentMotion"] = teUIProperty.sdkParam.extraInfo.mergeWithCurrentMotion;
        if ([teUIProperty.uiCategory isEqualToString:TEUI_GATEGORY_GREEN_BACKGROUND_V2_ITEM] &&
            teUIProperty.sdkParam &&
            teUIProperty.sdkParam.effectName) {
            
            for (TESDKParam *sdkParam in self.greenBackgroundV2Params) {
                if ([sdkParam.effectName isEqualToString:teUIProperty.sdkParam.effectName]) {
                    sdkParam.effectValue = teUIProperty.sdkParam.effectValue;
                }
            }
            NSMutableArray *greenParams = [[NSMutableArray alloc] init];
            for (TESDKParam *sdkParam in self.greenBackgroundV2Params) {
                [greenParams addObject:@(sdkParam.effectValue)];
            }
            self.extraInfo[@"green_params_v2"] = [NSString stringWithFormat:@"[%@]",[greenParams componentsJoinedByString:@","]];
            path = self.segmentationResPath;
            extraInfo = self.extraInfo;
        } else {
            self.segmentationResPath = nil;
            self.extraInfo = nil;
        }
        [self setBeauty:EFFECT_SEGMENTATION effectValue:0 resourcePath:path extraInfo:extraInfo abilityType: teUIProperty.abilityType save:YES];
    }
}

- (void)configSegmentation {
    if ([self.currentProperty.sdkParam.extraInfo.segType isEqualToString:TEUI_CUSTOM_BACKGROUND]) {//自定义背景
        [self.extraInfo setValue:self.custom_background_imagePath forKey:@"bgPath"];
        [self.extraInfo setValue:TEUI_CUSTOM_BACKGROUND forKey:@"segType"];
    } else if ([self.currentProperty.sdkParam.extraInfo.segType isEqualToString:TEUI_GREEN_BACKGROUND_V2] ||
               [self.currentProperty.uiCategory isEqualToString:TEUI_GATEGORY_GREEN_BACKGROUND_V2_ITEM_IMPORT_IMAGE]) {//绿幕V2
        [self.extraInfo setValue:self.green_background_v2_background_imagePath forKey:@"bgPath"];
        [self.extraInfo setValue:TEUI_GREEN_BACKGROUND_V2 forKey:@"segType"];
    } else {//绿幕V1
        [self.extraInfo setValue:self.green_background_imagePath forKey:@"bgPath"];
        [self.extraInfo setValue:TEUI_GREEN_BACKGROUND forKey:@"segType"];
        [self.extraInfo setValue:@"#0x00ff00" forKey:@"keyColor"];
    }
    if (!self.segmentationResPath && self.currentUIProperty.teCategory == TECategory_SEGMENTATION) {
        self.segmentationResPath = [self searchLocalResourceName:self.currentUIProperty.resourceUri dirPath:self.currentUIProperty.downloadPath];
    }
    [self.extraInfo setValue:[NSString stringWithFormat:@"%d", self.segmentationBgType] forKey:@"bgType"];
    self.extraInfo[@"mergeWithCurrentMotion"] = self.mergeCurMotion;
    
    [self.greenBackgroundV2Params removeAllObjects];
    for (TEUIProperty *property in self.currentUIProperty.propertyList) {
        if (property.sdkParam && property.sdkParam.effectName) {
            [self.greenBackgroundV2Params addObject:property.sdkParam];
        }
    }
    NSMutableArray *greenParams = [[NSMutableArray alloc] init];
    for (TESDKParam *sdkParam in self.greenBackgroundV2Params) {
        [greenParams addObject:@(sdkParam.effectValue)];
    }
    if (greenParams.count) {
        self.extraInfo[@"green_params_v2"] = [NSString stringWithFormat:@"[%@]",[greenParams componentsJoinedByString:@","]];
    } else {
        self.extraInfo[@"green_params_v2"] = @"[30,20,1,30,1]";
    }
    [self setBeauty:EFFECT_SEGMENTATION effectValue:0 resourcePath:self.segmentationResPath extraInfo:self.extraInfo abilityType:TEUI_SEGMENTATION save:YES];
}

- (void)syncEffectParamList:(NSArray<TESDKParam *> *)paramList {
    TEUIProperty *beautyData = [self.tePanelDataProvider getBeautyPanelData];
    TEUIProperty *beautyImageData = [self.tePanelDataProvider getBeautyImagePanelData];
    TEUIProperty *beautyShapeData = [self.tePanelDataProvider getBeautyShapePanelData];
    TEUIProperty *beautyMakeupData = [self.tePanelDataProvider getBeautyMakeupPanelData];
    TEUIProperty *lutData = [self.tePanelDataProvider getLutPanelData];
    //先重置初始状态
    [self setBeautyUIState:beautyData uiState:TEUIState_INIT];
    [self setBeautyUIState:beautyImageData uiState:TEUIState_INIT];
    [self setBeautyUIState:beautyShapeData uiState:TEUIState_INIT];
    [self setBeautyUIState:beautyMakeupData uiState:TEUIState_INIT];
    [self setBeautyUIState:lutData uiState:TEUIState_INIT];
    //再从模板数据中同步到对应模块
    for (TESDKParam *param in paramList) {
        [self searchAndSetUIState:param targetProperty:beautyData];
        [self searchAndSetUIState:param targetProperty:beautyImageData];
        [self searchAndSetUIState:param targetProperty:beautyShapeData];
        [self searchAndSetUIState:param targetProperty:beautyMakeupData];
        [self searchAndSetUIState:param targetProperty:lutData];
    }
}

- (BOOL)searchAndSetUIState:(TESDKParam *)param targetProperty:(TEUIProperty *)targetProperty {
    if (targetProperty.propertyList.count) {
        BOOL isFind = NO;
        for (TEUIProperty *child in targetProperty.propertyList) {
            //查找
            isFind = [self searchAndSetUIState:param targetProperty:child];
            if (isFind) {
                //找到子项中任一个就返回
                targetProperty.uiState = TEUIState_IN_USE;
                break;
            }
        }
        return isFind;
    } else {
        BOOL isEqual = NO;
        if ([TEUtils isBeauty:param.effectName]) {
            if (param.effectName) {
                isEqual = [param.effectName isEqualToString:targetProperty.sdkParam.effectName];
            }
            if (param.resourcePath) {
                isEqual = isEqual && [param.resourcePath isEqualToString:targetProperty.sdkParam.resourcePath];
            }
        } else {
            isEqual = [param.resourcePath isEqualToString:targetProperty.resourceUri];
        }
        if (isEqual) {
            //命中
            targetProperty.uiState = TEUIState_IN_USE;
            targetProperty.sdkParam.effectValue = param.effectValue;
            if (param.resourcePath) {
                targetProperty.uiState = TEUIState_CHECKED_AND_IN_USE;
            }
        }
        return isEqual;
    }
}

- (NSString *)searchLocalResourceName:(NSString *)name dirPath:(NSString *)dirPath {
    if (!name) {
        return nil;
    }
    //先从下载地址中查找
    NSString *path = [self fileExits:name dirPath:dirPath];
    if (path) {
        return path;
    }
    //再从bundle中查找
    for (NSString *bundleName in self.allBundleNames) {
        path = [[[NSBundle mainBundle] pathForResource:bundleName ofType:@"bundle"] stringByAppendingPathComponent:name.lastPathComponent];
        if ([[NSFileManager defaultManager] fileExistsAtPath:path]) {
            return path;
        }
    }
    return nil;
}

- (NSArray<NSString *> *)searchMutualExclusion:(NSString *)effectName {
    NSArray *results;
    for (NSArray *exclusionArray in self.tePanelDataProvider.exclusionGroup) {
        //确定当前效果在哪个分组，只跟同组的效果互斥
        if ([exclusionArray containsObject:effectName]) {
            results = exclusionArray;
            break;
        }
    }
    return results;
}

- (TEUIProperty *)searchInUseProperty:(NSArray<TEUIProperty *> *)propertyList {
    for (TEUIProperty *property in propertyList) {
        if (property.uiState == TEUIState_CHECKED_AND_IN_USE) {
            if (property.propertyList.count) {
                return [self searchInUseProperty:property.propertyList];
            } else {
                return property;
            }
        }
    }
    return nil;
}

- (void)setEnhancedMode:(BOOL)enhancedMode {
    _enhancedMode = enhancedMode;
    for (TESDKParam *param in _teBeautyKit.usedSDKParam) {
        if ([TEUtils isBeauty:param.effectName]) {
            [self setBeauty:param.effectName effectValue:param.effectValue resourcePath:param.resourcePath extraInfo:param.extraInfoDic abilityType:param.abilityType save:NO];
        }
    }
}

/// 清理特定索引开始的美颜特效对应的UI
- (void)clearLastBeautyUi:(TECategory)teCategory {
    for (TEUIProperty *property in self.currentUIPropertyList) {
        if (property.teCategory == teCategory) {
            if (teCategory == TECategory_BEAUTYMAKEUP) {
                for (TEUIProperty *model in property.propertyList) {
                    if ([self.beautyMakeupEffectNames containsObject:model.propertyList[0].sdkParam.effectName]) {
                        [self setBeautyUIState:model uiState:TEUIState_INIT];
                    }
                }
            } else {
                for (TEUIProperty *model in property.propertyList) {
                    [self setBeautyUIState:model uiState:TEUIState_INIT];
                }
            }
        }
    }
}

- (void)clearLightMakeup {
    [self setBeauty:EFFECT_LIGHT_MAKEUP effectValue:0 resourcePath:nil extraInfo:nil abilityType:nil save:YES];
}

- (void)setBeautyUIState:(TEUIProperty *)property uiState:(int)uiState {
    property.uiState = uiState;
    for (TEUIProperty *child in property.propertyList) {
        [self setBeautyUIState:child uiState:uiState];
    }
}

#pragma mark - 下载/本地缓存
- (void)downloadRes:(NSString *)category teUIProperty:(TEUIProperty *)teUIProperty {
    if (![TEUtils isURL:teUIProperty.resourceUri]) {
        return;
    }
    weakify(self);
    dispatch_async(dispatch_get_main_queue(), ^{
        strongify(self);
        //[self showLoading];
        if ([self.delegate respondsToSelector:@selector(teShowLoading)]) {
            [self.delegate teShowLoading];
        }
    });
    [[TEDownloader shardManager] download:teUIProperty.resourceUri destinationURL:teUIProperty.downloadPath progressBlock:^(CGFloat progress) {
        if ([self.delegate respondsToSelector:@selector(TEDownloaderProgressBlock:)]) {
            [self.delegate TEDownloaderProgressBlock:progress];
        }
    } successBlock:^(BOOL success, NSString *downloadFileLocalPath) {
        if ([self.delegate respondsToSelector:@selector(teDismissLoading)]) {
            [self.delegate teDismissLoading];
        }
        if (!success) {
            return;
        }
        strongify(self);
        if ([category isEqualToString:EFFECT_SEGMENTATION]) {
            [self setSegmentation:downloadFileLocalPath teUIProperty:teUIProperty];
            return;
        }
        NSString *makeupLutStrength = teUIProperty.sdkParam.extraInfo.makeupLutStrength;
        NSMutableDictionary *extraInfo = [NSMutableDictionary dictionary];
        extraInfo[@"mergeWithCurrentMotion"] = teUIProperty.sdkParam.extraInfo.mergeWithCurrentMotion;
        if ([category isEqualToString:EFFECT_MAKEUP]) {
            extraInfo[@"makeupLutStrength"] = makeupLutStrength;
        }
        [self setBeauty:category effectValue:teUIProperty.sdkParam.effectValue resourcePath:downloadFileLocalPath extraInfo:extraInfo abilityType:teUIProperty.abilityType save:YES];
    }];
}

- (NSString *)fileExits:(NSString *)resUri dirPath:(NSString *)dirPath {
    NSURL *downloadURL = [NSURL URLWithString:resUri];
    NSString *filename = downloadURL.lastPathComponent;
    if ([filename.pathExtension.lowercaseString isEqualToString:@"zip"]) {
        filename = [filename stringByDeletingPathExtension];
    }
    NSString *path =  [[[TEDownloader shardManager].basicPath stringByAppendingPathComponent:dirPath] stringByAppendingPathComponent:filename];
    if ([[NSFileManager defaultManager] fileExistsAtPath:path]) {
        return path;
    }
    return nil;
}

- (NSString *)convertPathToCustomPrefix:(NSString *)path {
    if (!path) {
        return nil;
    }
    NSString *retPath = [path stringByReplacingOccurrencesOfString:[TEDownloader shardManager].basicPath withString:@""];
    //去掉首部/
    return [retPath hasPrefix:@"/"] ? [retPath substringFromIndex:1] : retPath;
}

- (void)saveBeautyTemplate:(TEUIProperty *)templateProperty {
    //保存模板信息
    TESDKParam *param = [[TESDKParam alloc] init];
    param.effectName = TEUI_BEAUTY_TEMPLATE;
    param.effectValue = templateProperty.Id.intValue;
    param.abilityType = templateProperty.abilityType;
    NSMutableArray *paramList = [[NSMutableArray alloc] initWithCapacity:templateProperty.paramList.count];
    for (TESDKParam *subParam in templateProperty.paramList) {
        [paramList addObject:[subParam toDictionary]];
    }
    param.resourcePath = [TEUtils JSONObjectToString:paramList];
    [self.teBeautyKit saveEffectParam:param];
}

- (void)clearBeautyTemplate {
    //清空模板信息
    NSMutableArray<TESDKParam *> *inUseParamList =  [self.teBeautyKit getInUseSDKParamList];
    [inUseParamList enumerateObjectsWithOptions:NSEnumerationReverse usingBlock:^(TESDKParam * _Nonnull obj, NSUInteger idx, BOOL * _Nonnull stop) {
        if ([obj.effectName isEqualToString:TEUI_BEAUTY_TEMPLATE]) {
            [inUseParamList removeObject:obj];
            *stop = YES;
        }
    }];
    self.teBeautyKit.usedSDKParam = inUseParamList;
}

#pragma mark - 相册选择器回调
- (void)imagePickerFinish:(UIImage *)image picker:(UIImagePickerController *)picker {
    image = [TEUtils fixOrientation:image];
    NSData *data = UIImagePNGRepresentation(image);
    //返回为png图像。
    if (!data) {
        //返回为JPEG图像。
        data = UIImageJPEGRepresentation(image, 1.0);
    }
    NSDateFormatter *formatter = [[NSDateFormatter alloc] init];
    [formatter setDateFormat:@"yyyyMMddHHmmss"];
    NSString *dateStr = [formatter stringFromDate:[NSDate date]];
    if ([self.currentProperty.sdkParam.extraInfo.segType isEqualToString:TEUI_CUSTOM_BACKGROUND]) {
        NSString *newFileName = [NSString stringWithFormat:@"%@_%@.%@", TEUI_CUSTOM_BACKGROUND, dateStr, @"png"];
        self.custom_background_imagePath = [self createImagePath:newFileName];
        [[NSFileManager defaultManager] createFileAtPath:self.custom_background_imagePath contents:data attributes:nil];
    } else if ([self.currentProperty.sdkParam.extraInfo.segType isEqualToString:TEUI_GREEN_BACKGROUND_V2] ||
               [self.currentProperty.uiCategory isEqualToString:TEUI_GATEGORY_GREEN_BACKGROUND_V2_ITEM_IMPORT_IMAGE]) {
        NSString *newFileName = [NSString stringWithFormat:@"%@_%@.%@", TEUI_GREEN_BACKGROUND_V2, dateStr, @"png"];
        self.green_background_v2_background_imagePath = [self createImagePath:newFileName];
        [[NSFileManager defaultManager] createFileAtPath:self.green_background_v2_background_imagePath contents:data attributes:nil];
    } else {
        NSString *newFileName = [NSString stringWithFormat:@"%@_%@.%@", TEUI_GREEN_BACKGROUND, dateStr, @"png"];
        self.green_background_imagePath = [self createImagePath:newFileName];
        [[NSFileManager defaultManager] createFileAtPath:self.green_background_imagePath contents:data attributes:nil];
    }
    [picker dismissViewControllerAnimated:YES completion:nil];
    self.timeOffset = [NSNumber numberWithInt:0];
    self.segmentationBgType = 0;
    [self configSegmentation];
}

- (NSString *)createImagePath:(NSString *)fileName {
    NSString *documentPath = [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES) firstObject];
    NSString *imageDocPath = [documentPath stringByAppendingPathComponent:@"TencentEffect_MediaFile"];
    [[NSFileManager defaultManager] removeItemAtPath:imageDocPath error:nil];
    [[NSFileManager defaultManager] createDirectoryAtPath:imageDocPath withIntermediateDirectories:YES attributes:nil error:nil];
    return [imageDocPath stringByAppendingPathComponent:fileName];
}

- (void)moviePickerFinish:(NSURL *)sourceURL picker:(UIImagePickerController *)picker completionHandler:(void (^)(BOOL success, NSError * _Nullable error, NSInteger timeOffset))completionHandler {
    NSDateFormatter *formater = [[NSDateFormatter alloc] init];
    [formater setDateFormat:@"yyyy-MM-dd-HH.mm.ss"];
    NSURL *newVideoUrl = [NSURL fileURLWithPath:[NSHomeDirectory() stringByAppendingFormat:@"/Documents/output-%@.mp4", [formater stringFromDate:[NSDate date]]]];
    [picker dismissViewControllerAnimated:YES completion:nil];
    // 处理视频 压缩视频
    [self convertVideoQuailtyWithInputURL:sourceURL outputURL:newVideoUrl completeHandler:completionHandler];
}

#pragma mark - 视频压缩转码处理
- (void)convertVideoQuailtyWithInputURL:(NSURL*)inputURL
                              outputURL:(NSURL*)outputURL
                        completeHandler:(void (^)(BOOL success, NSError * _Nullable error, NSInteger timeOffset))handler {
    AVURLAsset *avAsset = [AVURLAsset URLAssetWithURL:inputURL options:nil];
    CMTime videoTime = [avAsset duration];
    int timeOffset = ceil(1000 * videoTime.value / videoTime.timescale) - 10;
    if (timeOffset > MAX_SEG_VIDEO_DURATION) {
        NSLog(@"background video too long(limit %i)", MAX_SEG_VIDEO_DURATION);
        if (handler) {
            NSError *error = [NSError errorWithDomain:@"VideoConvertErrorDomain"
                                                 code:5003
                                             userInfo:@{NSLocalizedDescriptionKey: @"Video duration exceeds limit"}];
            handler(NO,error,0);
        }
        return ;
    }
    AVAssetExportSession *exportSession = [[AVAssetExportSession alloc] initWithAsset:avAsset presetName:AVAssetExportPresetMediumQuality];
    exportSession.outputURL = outputURL;
    exportSession.outputFileType = AVFileTypeMPEG4;
    exportSession.shouldOptimizeForNetworkUse= YES;
    weakify(self);
    [exportSession exportAsynchronouslyWithCompletionHandler:^(void) {
        strongify(self);
        switch (exportSession.status) {
            case AVAssetExportSessionStatusCompleted:{
                NSLog(@"AVAssetExportSessionStatusCompleted");
                if (handler) {
                    handler(YES, nil, timeOffset);
                }
                if ([self.currentProperty.sdkParam.extraInfo.segType isEqualToString:TEUI_CUSTOM_BACKGROUND]) {
                    self.custom_background_imagePath = outputURL.path;
                } else if ([self.currentProperty.sdkParam.extraInfo.segType isEqualToString:TEUI_GREEN_BACKGROUND_V2] ||
                           [self.currentProperty.uiCategory isEqualToString:TEUI_GATEGORY_GREEN_BACKGROUND_V2_ITEM_IMPORT_IMAGE]) {
                    self.green_background_v2_background_imagePath = outputURL.path;
                } else {
                    self.green_background_imagePath = outputURL.path;
                }
                self.timeOffset = [NSNumber numberWithInt:timeOffset];
                self.segmentationBgType = 1;
                [self configSegmentation];
                break;
            }
            case AVAssetExportSessionStatusFailed:{
                NSLog(@"AVAssetExportSessionStatusFailed");
                NSError *error = [NSError errorWithDomain:@"VideoConvertErrorDomain"
                                                     code:5004
                                                 userInfo:exportSession.error.userInfo];
                if (handler){
                    handler(NO, error, 0);
                }
                break;
            }
            default: {
                // 其他状态（取消、未知、等待、导出中）
                NSLog(@"export session status: %ld", (long)exportSession.status);
                if (handler) {
                    NSError *error = [NSError errorWithDomain:@"VideoConvertErrorDomain"
                                                         code:5002
                                                     userInfo:@{NSLocalizedDescriptionKey: @"Video export failed"}];
                    handler(NO, error, 0);
                }
                break;
            }
        }
    }];
}

#pragma mark - //TODO: 设置自定义背景分割或者自定义绿幕的 自定义（图片或视频）资源
- (int)handleMediaAtPath:(NSString *)filePath {
    int errorCode = 0;
    return errorCode;
}


#pragma mark - lazy
- (NSMutableArray<NSString *> *)beautyMakeupEffectNames {
    if (!_beautyMakeupEffectNames) {
        _beautyMakeupEffectNames = [NSMutableArray arrayWithArray:@[
            BEAUTY_MOUTH_LIPSTICK,
            BEAUTY_FACE_RED_CHEEK,
            BEAUTY_FACE_SOFTLIGHT,
            BEAUTY_FACE_EYE_SHADOW,
            BEAUTY_FACE_EYE_LINER,
            BEAUTY_FACE_EYELASH,
            BEAUTY_FACE_EYE_SEQUINS,
            BEAUTY_FACE_EYEBROW,
            BEAUTY_FACE_EYEBALL,
            BEAUTY_FACE_EYELIDS,
            BEAUTY_FACE_EYEWOCAN]];
    }
    return _beautyMakeupEffectNames;
}

- (NSArray *)allBundleNames {
    if (!_allBundleNames) {
        _allBundleNames = @[@"lut",
                            @"lightMakeupRes",
                            @"2dMotionRes",
                            @"3dMotionRes",
                            @"handMotionRes",
                            @"ganMotionRes",
                            @"makeupMotionRes",
                            @"segmentMotionRes"];
    }
    return _allBundleNames;
}

- (NSMutableDictionary *)extraInfo {
    if (!_extraInfo) {
        _extraInfo = [[NSMutableDictionary alloc] init];
    }
    return _extraInfo;
}

- (NSMutableArray *)greenBackgroundV2Params {
    if (!_greenBackgroundV2Params) {
        _greenBackgroundV2Params = [[NSMutableArray alloc] init];
    }
    return _greenBackgroundV2Params;
}

@end
