//
//  TEPanelDataProvider.h
//  TEBeautyKit
//
//  Created by tao yue on 2024/1/8.
//

#import <Foundation/Foundation.h>
#import "TEUIProperty.h"

@interface TEPanelDataProvider : NSObject

//单点能力-用来设置美颜组合的顺序
@property (nonatomic, strong) NSMutableArray<NSString *> *abilitiesBeautyArray;
@property (nonatomic, strong) NSMutableArray<NSString *> *abilitiesMakeupArray;
@property (nonatomic, strong) NSMutableArray<NSString *> *abilitiesMotionArray;
//美颜、美妆模板
@property (nonatomic, strong) NSMutableArray<NSString *> *abilitiesTemplateArray;
@property (nonatomic, strong) NSMutableArray<NSString *> *abilitiesTemplateBeautyArray;
//A/S系列套餐：
@property (nonatomic, strong) NSArray<NSString *> *motionOfCombos;
@property (nonatomic, strong) NSArray<NSString *> *makeupOfCombos;
//原子能力
@property (nonatomic, strong) NSMutableArray<NSString *> *capabilitiesArray;
//美颜互斥组合
@property (nonatomic, strong) NSArray<NSArray<NSString *> *> *exclusionGroup;
//单点美妆组合
@property (nonatomic, strong) NSArray<NSString *> *beautyMakeupNoneGroup;
//增强模式倍率
@property (nonatomic, strong) NSMutableDictionary *enhancedMultipleDictionary;

+ (instancetype)shareInstance;

/// 获取TEUIConfig配置的美颜模板数据
- (TEUIProperty *)getBeautyTemplatePanelData;
/// 获取TEUIConfig配置的美颜数据
- (TEUIProperty *)getBeautyPanelData;
/// 获取TEUIConfig配置的美型数据
- (TEUIProperty *)getBeautyShapePanelData;
/// 获取TEUIConfig配置的画质数据
- (TEUIProperty *)getBeautyImagePanelData;
/// 获取TEUIConfig配置的单点美妆数据
- (TEUIProperty *)getBeautyMakeupPanelData;
/// 获取TEUIConfig配置的轻美妆数据
- (TEUIProperty *)getLightMakeupPanelData;
/// 获取TEUIConfig配置的滤镜数据
- (TEUIProperty *)getLutPanelData;
/// 获取TEUIConfig配置的美体数据
- (TEUIProperty *)getBeautyBodyPanelData;
/// 获取TEUIConfig配置的动效数据
- (TEUIProperty *)getMotionPanelData;
/// 获取TEUIConfig配置的轻贴纸数据
- (TEUIProperty *)getLightMotionPanelData;
/// 获取TEUIConfig配置的2d动效数据
- (TEUIProperty *)getMotion2dPanelData;
/// 获取TEUIConfig配置的3d动效数据
- (TEUIProperty *)getMotion3dPanelData;
/// 获取TEUIConfig配置的手势动效数据
- (TEUIProperty *)getMotionHandPanelData;
/// 获取TEUIConfig配置的美妆数据
- (TEUIProperty *)getMakeupPanelData;
/// 获取TEUIConfig配置的背景分割数据
- (TEUIProperty *)getSegmentationPanelData;

/// 获取面板数据
- (NSMutableArray<TEUIProperty *>*)getAllPanelData;

/// 基础美颜
- (TEUIProperty *)getBeautyBaseShapeData;
/// 美体
- (TEUIProperty *)getBeautyBodyData;
/// 通用美颜
- (TEUIProperty *)getBeautyGeneralShapeData;
/// 画质调整
- (TEUIProperty *)getBeautyImageData;
/// 单点美妆
- (TEUIProperty *)getBeautyMakeupData;
/// 高级美型
- (TEUIProperty *)getBeautyShapeData;
/// 美颜模板
- (TEUIProperty *)getBeautyTemplateData;
/// 美颜
- (TEUIProperty *)getBeautyData;
/// 原子能力
- (NSMutableArray<TEUIProperty *> *)getCapabilitiesListData;
/// 滤镜
- (TEUIProperty *)getLutData;
/// 美妆
- (TEUIProperty *)getMakeupData;
/// 轻美妆
- (TEUIProperty *)getLightMakeupData;
/// 贴纸
- (TEUIProperty *)getMotionData;
/// 轻贴纸
- (TEUIProperty *)getLightMotionData;
/// 2D动效
- (TEUIProperty *)getMotion2dData;
/// 3D动效
- (TEUIProperty *)getMotion3dData;
/// 手势动效
- (TEUIProperty *)getMotionGestureData;
/// 运镜动效
- (TEUIProperty *)getMotionCameraMoveData;
/// 背景分割
- (TEUIProperty *)getPortraitSegmentationData;
/// 背景分割
- (TEUIProperty *)getSegmentationData;

/// 根据套餐获取美颜组合
- (NSMutableArray<TEUIProperty *> *)getAbilitiesBeautyData:(NSString *)comboType;
- (NSMutableArray<TEUIProperty *> *)getAbilitiesMakeupData:(NSString *)comboType;
- (NSMutableArray<TEUIProperty *> *)getAbilitiesMotionData:(NSString *)comboType;
- (NSMutableArray<TEUIProperty *> *)getAbilitiesTemplateData:(NSString *)comboType;
- (NSMutableArray<TEUIProperty *> *)getAbilitiesTemplateBeautyData;

/// 设置美颜增强属性
- (void)setEnhancedMultiple:(NSMutableDictionary *)enhancedMultiple;
/// 清空数据
- (void)clearData;
/// 清空动效和滤镜
- (void)clearMotionLutData;

@end

