//
//  TEPanelDataProvider.m
//  TEBeautyKit
//
//  Created by tao yue on 2024/1/8.
//

#import "TEPanelDataProvider.h"
#import "TEUIProperty.h"
#import <XMagic/XmagicConstant.h>
#import "TEUIConfig.h"
#import "TEUIDefine.h"

@interface TEPanelDataProvider()

@property(nonatomic, strong)NSMutableArray *savedEffectName;
/// 美颜模板数据
@property (nonatomic ,strong) TEUIProperty *beautyTemplatePanelData;
/// 美颜数据
@property (nonatomic ,strong) TEUIProperty *beautyPanelData;
/// 美型数据
@property (nonatomic ,strong) TEUIProperty *beautyShapePanelData;
/// 画质数据
@property (nonatomic ,strong) TEUIProperty *beautyImagePanelData;
/// 单点美妆数据
@property (nonatomic ,strong) TEUIProperty *beautyMakeupPanelData;
/// 轻美妆
@property (nonatomic ,strong) TEUIProperty *lightMakeupPanelData;
/// 滤镜数据
@property (nonatomic ,strong) TEUIProperty *lutPanelData;
/// 美体数据
@property (nonatomic ,strong) TEUIProperty *beautyBodyPanelData;
/// 动效数据
@property (nonatomic ,strong) TEUIProperty *motionPanelData;
/// 轻贴纸数据
@property (nonatomic ,strong) TEUIProperty *lightMotionPanelData;
/// 2d动效数据
@property (nonatomic ,strong) TEUIProperty *motion2dPanelData;
/// 3d动效数据
@property (nonatomic ,strong) TEUIProperty *motion3dPanelData;
/// 手势动效数据
@property (nonatomic ,strong) TEUIProperty *motionHandPanelData;
/// 美妆数据
@property (nonatomic ,strong) TEUIProperty *makeupPanelData;
/// 背景分割数据
@property (nonatomic ,strong) TEUIProperty *segmentationPanelData;


/// 美颜模板
@property (nonatomic ,strong) TEUIProperty *beautyTemplateData;
/// 美颜
@property (nonatomic ,strong) TEUIProperty *beautyData;
/// 基础美颜
@property (nonatomic ,strong) TEUIProperty *beautyBaseShapeData;
/// 通用美颜
@property (nonatomic ,strong) TEUIProperty *beautyGeneralShapeData;
/// 高级美颜
@property (nonatomic ,strong) TEUIProperty *beautyShapeData;
/// 画质调整
@property (nonatomic ,strong) TEUIProperty *beautyImageData;
/// 单点美妆
@property (nonatomic ,strong) TEUIProperty *beautyMakeupData;
/// 轻美妆
@property (nonatomic ,strong) TEUIProperty *lightMakeupData;
/// 滤镜
@property (nonatomic ,strong) TEUIProperty *lutData;
/// 美体
@property (nonatomic ,strong) TEUIProperty *beautyBodyData;
/// 贴纸
@property (nonatomic ,strong) TEUIProperty *motionData;
/// 2D动效
@property (nonatomic ,strong) TEUIProperty *motion2dData;
/// 3D动效
@property (nonatomic ,strong) TEUIProperty *motion3dData;
/// 轻贴纸
@property (nonatomic ,strong) TEUIProperty *lightMotionData;
/// 美妆
@property (nonatomic ,strong) TEUIProperty *makeupData;
/// 分割
@property (nonatomic ,strong) TEUIProperty *segmentationData;
/// 手势动效
@property (nonatomic ,strong) TEUIProperty *motionGestureData;
/// 运镜动效
@property (nonatomic ,strong) TEUIProperty *motionCameraMoveData;
/// 虚拟背景
@property (nonatomic ,strong) TEUIProperty *portraitSegmentationData;
/// 原子能力
@property (nonatomic ,strong) NSMutableArray<TEUIProperty *> *capabilitiesListData;
/// 美颜集合
@property (nonatomic ,strong) NSMutableArray<TEUIProperty *> *abilitiesBeautyData;
/// 美颜模板-美颜
@property (nonatomic ,strong) TEUIProperty *templateBeautyData;
/// 美颜模板-画质调整
@property (nonatomic ,strong) TEUIProperty *templateBeautyImageData;
/// 美颜模板-高级美颜
@property (nonatomic ,strong) TEUIProperty *templateBeautyShapeData;
/// 美颜模板-单点美妆
@property (nonatomic ,strong) TEUIProperty *templateBeautyMakeupData;

@end

@implementation TEPanelDataProvider

+ (instancetype)shareInstance {
    static TEPanelDataProvider *tePanelDataProvider;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        if (tePanelDataProvider == nil) {
            tePanelDataProvider = [[TEPanelDataProvider alloc] init];
        }
    });
    return tePanelDataProvider;
}

- (TEUIProperty *)getBeautyTemplatePanelData {
    if (!_beautyTemplatePanelData) {
        NSDictionary *dic = [self readLocalFileWithPath:[[TEUIConfig shareInstance] getBeautyTemplatePath]];
        if (dic == nil) {
            return nil;
        }
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_TEMPLATE;
        uiproperty.abilityType = TEUI_BEAUTY_TEMPLATE;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _beautyTemplatePanelData = uiproperty;
    }
    return _beautyTemplatePanelData;
}

- (TEUIProperty *)getBeautyPanelData {
    if (!_beautyPanelData) {
        NSDictionary *dic = [self readLocalFileWithPath:[[TEUIConfig shareInstance] getBeautyPath]];
        if (dic == nil) {
            return nil;
        }
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_BEAUTY;
        uiproperty.abilityType = TEUI_BEAUTY;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _beautyPanelData = uiproperty;
    }
    return _beautyPanelData;
}

- (TEUIProperty *)getBeautyShapePanelData {
    if (!_beautyShapePanelData) {
        NSDictionary *dic = [self readLocalFileWithPath:[[TEUIConfig shareInstance] getBeautyShapePath]];
        if (dic == nil) {
            return nil;
        }
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_BEAUTY;
        uiproperty.abilityType = TEUI_BEAUTY_SHAPE;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _beautyShapePanelData = uiproperty;
    }
    return _beautyShapePanelData;
}

- (TEUIProperty *)getBeautyImagePanelData {
    if (!_beautyImagePanelData) {
        NSDictionary *dic = [self readLocalFileWithPath:[[TEUIConfig shareInstance] getBeautyImagePath]];
        if (dic == nil) {
            return nil;
        }
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_BEAUTY;
        uiproperty.abilityType = TEUI_BEAUTY_IMAGE;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _beautyImagePanelData = uiproperty;
    }
    return _beautyImagePanelData;
}

- (TEUIProperty *)getBeautyMakeupPanelData {
    if (!_beautyMakeupPanelData) {
        NSDictionary *dic = [self readLocalFileWithPath:[[TEUIConfig shareInstance] getBeautyMakeupPath]];
        if (dic == nil) {
            return nil;
        }
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_BEAUTYMAKEUP;
        uiproperty.abilityType = TEUI_BEAUTY_MAKEUP;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _beautyMakeupPanelData = uiproperty;
    }
    return _beautyMakeupPanelData;
}

- (TEUIProperty *)getLightMakeupPanelData {
    if (!_lightMakeupPanelData) {
        NSDictionary *dic = [self readLocalFileWithPath:[[TEUIConfig shareInstance] getLightMakeupPath]];
        if (dic == nil) {
            return nil;
        }
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_LIGHTMAKEUP;
        uiproperty.abilityType = TEUI_LIGHT_MAKEUP;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _lightMakeupPanelData = uiproperty;
    }
    return _lightMakeupPanelData;
}

- (TEUIProperty *)getLutPanelData {
    if (!_lutPanelData) {
        NSDictionary *dic = [self readLocalFileWithPath:[[TEUIConfig shareInstance] getLutPath]];
        if (dic == nil) {
            return nil;
        }
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_LUT;
        uiproperty.abilityType = TEUI_LUT;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _lutPanelData = uiproperty;
    }
    return _lutPanelData;
}

- (TEUIProperty *)getBeautyBodyPanelData {
    if (!_beautyBodyPanelData) {
        NSDictionary *dic = [self readLocalFileWithPath:[[TEUIConfig shareInstance] getBeautyBodyPath]];
        if (dic == nil) {
            return nil;
        }
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_BEAUTY;
        uiproperty.abilityType = TEUI_BEAUTY_BODY;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _beautyBodyPanelData = uiproperty;
    }
    return _beautyBodyPanelData;
}

- (TEUIProperty *)getMotionPanelData {
    if (!_motionPanelData) {
        NSDictionary *dic = [self readLocalFileWithPath:[[TEUIConfig shareInstance] getMotionPath]];
        if (dic == nil) {
            return nil;
        }
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_MOTION;
        uiproperty.abilityType = TEUI_MOTION;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _motionPanelData = uiproperty;
    }
    return _motionPanelData;
}

- (TEUIProperty *)getLightMotionPanelData {
    if (!_lightMotionPanelData) {
        NSDictionary *dic = [self readLocalFileWithPath:[[TEUIConfig shareInstance] getLightMotionPath]];
        if (dic == nil) {
            return nil;
        }
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_MOTION;
        uiproperty.abilityType = TEUI_MOTION;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _lightMotionPanelData = uiproperty;
    }
    return _lightMotionPanelData;
}

- (TEUIProperty *)getMotion2dPanelData {
    if (!_motion2dPanelData) {
        NSDictionary *dic = [self readLocalFileWithPath:[[TEUIConfig shareInstance] getMotion2dPath]];
        if (dic == nil) {
            return nil;
        }
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_MOTION;
        uiproperty.abilityType = TEUI_MOTION_2D;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _motion2dPanelData = uiproperty;
    }
    return _motion2dPanelData;
}

- (TEUIProperty *)getMotion3dPanelData {
    if (!_motion3dPanelData) {
        NSDictionary *dic = [self readLocalFileWithPath:[[TEUIConfig shareInstance] getMotion3dPath]];
        if (dic == nil) {
            return nil;
        }
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_MOTION;
        uiproperty.abilityType = TEUI_MOTION_3D;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _motion3dPanelData = uiproperty;
    }
    return _motion3dPanelData;
}

- (TEUIProperty *)getMotionHandPanelData {
    if (!_motionHandPanelData) {
        NSDictionary *dic = [self readLocalFileWithPath:[[TEUIConfig shareInstance] getMotionHandPath]];
        if (dic == nil) {
            return nil;
        }
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_MOTION;
        uiproperty.abilityType = TEUI_MOTION_GESTURE;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _motionHandPanelData = uiproperty;
    }
    return _motionHandPanelData;
}

- (TEUIProperty *)getMakeupPanelData {
    if (!_makeupPanelData) {
        NSDictionary *dic = [self readLocalFileWithPath:[[TEUIConfig shareInstance] getMakeupPath]];
        if (dic == nil) {
            return nil;
        }
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_MAKEUP;
        uiproperty.abilityType = TEUI_MAKEUP;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _makeupPanelData = uiproperty;
    }
    return _makeupPanelData;
}

- (TEUIProperty *)getSegmentationPanelData {
    if (!_segmentationPanelData) {
        NSDictionary *dic = [self readLocalFileWithPath:[[TEUIConfig shareInstance] getSegmentationPath]];
        if (dic == nil) {
            return nil;
        }
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_SEGMENTATION;
        uiproperty.abilityType = TEUI_SEGMENTATION;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _segmentationPanelData = uiproperty;
    }
    return _segmentationPanelData;
}

- (NSMutableArray<TEUIProperty *> *)getAllPanelData {
    NSMutableArray<TEUIProperty *>*allPanelData = [NSMutableArray array];
    for (NSDictionary *dic in [[TEUIConfig shareInstance] getTEPanelViewResources]) {
        if ([dic.allKeys.firstObject isEqualToString:TEUI_BEAUTY_TEMPLATE]) {
            /// 美颜模板
            if ([self getBeautyTemplatePanelData] != nil) {
                [allPanelData addObject:_beautyTemplatePanelData];
            }
        } else if ([dic.allKeys.firstObject isEqualToString:TEUI_BEAUTY]) {
            /// 美颜
            if ([self getBeautyPanelData] != nil) {
                [allPanelData addObject:_beautyPanelData];
            }
        } else if ([dic.allKeys.firstObject isEqualToString:TEUI_BEAUTY_SHAPE]) {
            /// 美型
            if ([self getBeautyShapePanelData] != nil) {
                [allPanelData addObject:_beautyShapePanelData];
            }
        } else if ([dic.allKeys.firstObject isEqualToString:TEUI_BEAUTY_IMAGE]) {
            /// 画质
            if ([self getBeautyImagePanelData] != nil) {
                [allPanelData addObject:_beautyImagePanelData];
            }
        } else if ([dic.allKeys.firstObject isEqualToString:TEUI_BEAUTY_MAKEUP]) {
            /// 单点美妆
            if ([self getBeautyMakeupPanelData] != nil) {
                [allPanelData addObject:_beautyMakeupPanelData];
            }
        } else if ([dic.allKeys.firstObject isEqualToString:TEUI_LIGHT_MAKEUP]) {
            /// 轻美妆
            if ([self getLightMakeupPanelData] != nil) {
                [allPanelData addObject:_lightMakeupPanelData];
            }
        } else if ([dic.allKeys.firstObject isEqualToString:TEUI_LUT]) {
            /// 滤镜
            if ([self getLutPanelData] != nil) {
                [allPanelData addObject:_lutPanelData];
            }
        } else if ([dic.allKeys.firstObject isEqualToString:TEUI_BEAUTY_BODY]) {
            /// 美体
            if ([self getBeautyBodyPanelData] != nil) {
                [allPanelData addObject:_beautyBodyPanelData];
            }
        } else if ([dic.allKeys.firstObject isEqualToString:TEUI_MOTION]) {
            /// 贴纸
            if ([self getMotionPanelData] != nil) {
                [allPanelData addObject:_motionPanelData];
            }
        } else if ([dic.allKeys.firstObject isEqualToString:TEUI_LIGHT_MOTION]) {
            /// 轻贴纸
            if ([self getLightMotionPanelData] != nil) {
                [allPanelData addObject:_lightMotionPanelData];
            }
        } else if ([dic.allKeys.firstObject isEqualToString:TEUI_MOTION_2D]) {
            /// 2d贴纸
            if ([self getMotion2dPanelData] != nil) {
                [allPanelData addObject:_motion2dPanelData];
            }
        } else if ([dic.allKeys.firstObject isEqualToString:TEUI_MOTION_3D]) {
            /// 3d贴纸
            if ([self getMotion3dPanelData] != nil) {
                [allPanelData addObject:_motion3dPanelData];
            }
        } else if ([dic.allKeys.firstObject isEqualToString:TEUI_MOTION_GESTURE]) {
            /// 手势贴纸
            if ([self getMotionHandPanelData] != nil) {
                [allPanelData addObject:_motionHandPanelData];
            }
        } else if ([dic.allKeys.firstObject isEqualToString:TEUI_MAKEUP]) {
            /// 整装
            if ([self getMakeupPanelData] != nil) {
                [allPanelData addObject:_makeupPanelData];
            }
        } else if ([dic.allKeys.firstObject isEqualToString:TEUI_SEGMENTATION]) {
            /// 背景分割
            if ([self getSegmentationPanelData] != nil) {
                [allPanelData addObject:_segmentationPanelData];
            }
        }
    }
    return allPanelData;
}

- (TEUIProperty *)getBeautyBaseShapeData {
    if (!_beautyBaseShapeData) {
        NSDictionary *dic = [self readLocalFileWithName:@"beauty_base_shape"];
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_BEAUTY;
        uiproperty.abilityType = TEUI_BEAUTY_BASIC;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _beautyBaseShapeData = uiproperty;
    }
    return _beautyBaseShapeData;
}

- (TEUIProperty *)getBeautyBodyData {
    if (!_beautyBodyData) {
        NSDictionary *dic = [self readLocalFileWithName:@"beauty_body"];
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_BEAUTY;
        uiproperty.abilityType = TEUI_BEAUTY_BODY;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _beautyBodyData = uiproperty;
    }
    return _beautyBodyData;
}

- (TEUIProperty *)getBeautyGeneralShapeData {
    if (!_beautyGeneralShapeData) {
        NSDictionary *dic = [self readLocalFileWithName:@"beauty_general_shape"];
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_BEAUTY;
        uiproperty.abilityType = TEUI_BEAUTY_GENERAL;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _beautyGeneralShapeData = uiproperty;
    }
    return _beautyGeneralShapeData;
}

- (TEUIProperty *)getBeautyImageData {
    if (!_beautyImageData) {
        NSDictionary *dic = [self readLocalFileWithName:@"beauty_image"];
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_BEAUTY;
        uiproperty.abilityType = TEUI_BEAUTY_IMAGE;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _beautyImageData = uiproperty;
    }
    return _beautyImageData;
}

- (TEUIProperty *)getBeautyMakeupData {
    if (!_beautyMakeupData) {
        NSDictionary *dic = [self readLocalFileWithName:@"beauty_makeup"];
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_BEAUTY;
        uiproperty.abilityType = TEUI_BEAUTY_MAKEUP;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _beautyMakeupData = uiproperty;
    }
    return _beautyMakeupData;
}

- (TEUIProperty *)getBeautyShapeData {
    if (!_beautyShapeData) {
        NSDictionary *dic = [self readLocalFileWithName:@"beauty_shape"];
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_BEAUTY;
        uiproperty.abilityType = TEUI_BEAUTY_SHAPE;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _beautyShapeData = uiproperty;
    }
    return _beautyShapeData;
}

- (TEUIProperty *)getBeautyTemplateData {
    if (!_beautyTemplateData) {
        NSDictionary *dic = [self readLocalFileWithName:@"beauty_template_ios"];
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_TEMPLATE;
        uiproperty.abilityType = TEUI_BEAUTY_TEMPLATE;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _beautyTemplateData = uiproperty;
    }
    return _beautyTemplateData;
}

- (TEUIProperty *)getBeautyData {
    if (!_beautyData) {
        NSDictionary *dic = [self readLocalFileWithName:@"beauty"];
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_BEAUTY;
        uiproperty.abilityType = TEUI_BEAUTY;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _beautyData = uiproperty;
    }
    return _beautyData;
}

- (TEUIProperty * )getLutData {
    if (!_lutData) {
        NSDictionary *dic = [self readLocalFileWithName:@"lut"];
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_LUT;
        uiproperty.abilityType = TEUI_LUT;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _lutData = uiproperty;
    }
    return _lutData;
}

- (TEUIProperty *)getMakeupData {
    if (!_makeupData) {
        NSDictionary *dic = [self readLocalFileWithName:@"makeup"];
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_MAKEUP;
        uiproperty.abilityType = TEUI_MAKEUP;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _makeupData = uiproperty;
    }
    return _makeupData;
}

- (TEUIProperty *)getLightMakeupData {
    if (!_lightMakeupData) {
        NSDictionary *dic = [self readLocalFileWithName:@"light_makeup"];
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_LIGHTMAKEUP;
        uiproperty.abilityType = TEUI_LIGHT_MAKEUP;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _lightMakeupData = uiproperty;
    }
    return _lightMakeupData;
}

- (TEUIProperty *)getMotionData {
    if (!_motionData) {
        NSDictionary *dic = [self readLocalFileWithName:@"motion"];
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_MOTION;
        uiproperty.abilityType = TEUI_MOTION;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _motionData = uiproperty;
    }
    return _motionData;
}

- (TEUIProperty *)getLightMotionData {
    if (!_lightMotionData) {
        NSDictionary *dic = [self readLocalFileWithName:@"light_motion"];
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_MOTION;
        uiproperty.abilityType = TEUI_LIGHT_MOTION;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _lightMotionData = uiproperty;
    }
    return _lightMotionData;
}

- (TEUIProperty *)getMotion2dData {
    if (!_motion2dData) {
        NSDictionary *dic = [self readLocalFileWithName:@"motion_2d"];
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_MOTION;
        uiproperty.abilityType = TEUI_MOTION_2D;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _motion2dData = uiproperty;
    }
    return _motion2dData;
}

- (TEUIProperty *)getMotion3dData {
    if (!_motion3dData) {
        NSDictionary *dic = [self readLocalFileWithName:@"motion_3d"];
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_MOTION;
        uiproperty.abilityType = TEUI_MOTION_3D;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _motion3dData = uiproperty;
    }
    return _motion3dData;
}

- (TEUIProperty *)getMotionGestureData {
    if (!_motionGestureData) {
        NSDictionary *dic = [self readLocalFileWithName:@"motion_gesture"];
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_MOTION;
        uiproperty.abilityType = TEUI_MOTION_GESTURE;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _motionGestureData = uiproperty;
    }
    return _motionGestureData;
}

- (TEUIProperty *)getMotionCameraMoveData {
    if (!_motionCameraMoveData) {
        NSDictionary *dic = [self readLocalFileWithName:@"motion_camera_move"];
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_MOTION;
        uiproperty.abilityType = TEUI_MOTION_CAMERA_MOVE;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _motionCameraMoveData = uiproperty;
    }
    return _motionCameraMoveData;
}

- (TEUIProperty *)getPortraitSegmentationData {
    if (!_portraitSegmentationData) {
        NSDictionary *dic = [self readLocalFileWithName:@"portrait_segmentation"];
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_SEGMENTATION;
        uiproperty.abilityType = TEUI_PORTRAIT_SEGMENTATION;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _portraitSegmentationData = uiproperty;
    }
    return _portraitSegmentationData;
}

- (TEUIProperty *)getSegmentationData {
    if (!_segmentationData) {
        NSDictionary *dic = [self readLocalFileWithName:@"segmentation"];
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_SEGMENTATION;
        uiproperty.abilityType = TEUI_SEGMENTATION;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _segmentationData = uiproperty;
    }
    return _segmentationData;
}

- (TEUIProperty *)getTemplateBeautyData {
    if (!_templateBeautyData) {
        NSDictionary *dic = [self readLocalFileWithName:@"beauty"];
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_BEAUTY;
        uiproperty.abilityType = TEUI_BEAUTY;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _templateBeautyData = uiproperty;
    }
    return _templateBeautyData;
}

- (TEUIProperty *)getTemplateBeautyImageData {
    if (!_templateBeautyImageData) {
        NSDictionary *dic = [self readLocalFileWithName:@"beauty_image"];
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_BEAUTY;
        uiproperty.abilityType = TEUI_BEAUTY_IMAGE;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _templateBeautyImageData = uiproperty;
    }
    return _templateBeautyImageData;
}

- (TEUIProperty *)getTemplateBeautyShapeData {
    if (!_templateBeautyShapeData) {
        NSDictionary *dic = [self readLocalFileWithName:@"beauty_shape"];
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_BEAUTY;
        uiproperty.abilityType = TEUI_BEAUTY_SHAPE;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _templateBeautyShapeData = uiproperty;
    }
    return _templateBeautyShapeData;
}

- (TEUIProperty *)getTemplateBeautyMakeupData {
    if (!_templateBeautyMakeupData) {
        NSDictionary *dic = [self readLocalFileWithName:@"beauty_makeup"];
        TEUIProperty *uiproperty = [TEUIProperty new];
        uiproperty.teCategory = TECategory_BEAUTY;
        uiproperty.abilityType = TEUI_BEAUTY_MAKEUP;
        [uiproperty setValuesForKeysWithDictionary:dic];
        _templateBeautyMakeupData = uiproperty;
    }
    return _templateBeautyMakeupData;
}


- (NSMutableArray<TEUIProperty *> *)getCapabilitiesListData {
    if (!self.capabilitiesArray) {
        self.capabilitiesArray = [NSMutableArray array];
        [self.capabilitiesArray addObject:@"FACE_DETECTION"];
        [self.capabilitiesArray addObject:@"GESTURE_DETECTION"];
    }
    if (!_capabilitiesListData) {
        NSMutableArray<TEUIProperty *> *teuiPropertylist = [NSMutableArray array];
        NSDictionary *arrays = [self readLocalFileWithName:@"capabilities_list"];
        for (NSDictionary *dic in arrays) {
            TEUIProperty *teuiProperty = [TEUIProperty new];
            [teuiProperty setValuesForKeysWithDictionary:dic];
            [teuiPropertylist addObject:teuiProperty];
        }
        _capabilitiesListData = teuiPropertylist;
    }
    return _capabilitiesListData;
}


- (NSMutableArray<TEUIProperty *> *)getAbilitiesBeautyData:(NSString *)comboType {
    [self getBeautyData];
    [self getBeautyImageData];
    [self getBeautyShapeData];
    [self getBeautyBodyData];
    [self getBeautyBaseShapeData];
    [self getBeautyGeneralShapeData];
    NSMutableArray<TEUIProperty *> *array = [NSMutableArray array];
    self.abilitiesBeautyArray = [NSMutableArray array];
    if ([comboType isEqualToString:@"A1-00"]) {
        [array addObject:self.beautyData];
        [self.abilitiesBeautyArray addObject:TEUI_BEAUTY];
    } else if ([comboType isEqualToString:@"A1-01"] ||
              [comboType isEqualToString:@"A1-02"] ||
              [comboType isEqualToString:@"A1-05"] ||
              [comboType isEqualToString:@"A1-06"]) {
        [array addObjectsFromArray:@[self.beautyData,self.beautyImageData,self.beautyBaseShapeData]];
        [self.abilitiesBeautyArray addObjectsFromArray:@[TEUI_BEAUTY,TEUI_BEAUTY_IMAGE,TEUI_BEAUTY_BASIC]];
    } else if ([comboType isEqualToString:@"A1-03"] ||
              [comboType isEqualToString:@"A1-04"]) {
        [array addObjectsFromArray:@[self.beautyData,self.beautyImageData,self.beautyGeneralShapeData]];
        [self.abilitiesBeautyArray addObjectsFromArray:@[TEUI_BEAUTY,TEUI_BEAUTY_IMAGE,TEUI_BEAUTY_GENERAL]];
    } else if ([comboType isEqualToString:@"S1-00"] ||
              [comboType isEqualToString:@"S1-01"] ||
              [comboType isEqualToString:@"S1-02"] ||
              [comboType isEqualToString:@"S1-03"] ||
              [comboType isEqualToString:@"S1-04"]) {
        [array addObjectsFromArray:@[self.beautyData,self.beautyImageData,self.beautyShapeData]];
        [self.abilitiesBeautyArray addObjectsFromArray:@[TEUI_BEAUTY,TEUI_BEAUTY_IMAGE,TEUI_BEAUTY_SHAPE]];
    }else{
        [array addObjectsFromArray:@[self.beautyData,self.beautyImageData,self.beautyShapeData,self.beautyBodyData]];
        [self.abilitiesBeautyArray addObjectsFromArray:@[TEUI_BEAUTY,TEUI_BEAUTY_IMAGE,TEUI_BEAUTY_SHAPE,TEUI_BEAUTY_BODY]];
    }
    return array;
}

- (NSMutableArray<TEUIProperty *> *)getAbilitiesMakeupData:(NSString *)comboType {
    [self getBeautyMakeupData];
    [self getLightMakeupData];
    NSMutableArray<TEUIProperty *> *array = [NSMutableArray array];
    self.abilitiesMakeupArray = [NSMutableArray array];
    if ([comboType isEqualToString:@"A1-06"]) {
        [array addObject:self.lightMakeupData];
        [self.abilitiesMakeupArray addObject:TEUI_LIGHT_MAKEUP];
    } else if ([comboType isEqualToString:@"S1-00"]) {
        [array addObject:self.beautyMakeupData];
        [self.abilitiesMakeupArray addObject:TEUI_BEAUTY_MAKEUP];
    }else{
        [array addObject:self.beautyMakeupData];
        [array addObject:self.lightMakeupData];
        [self.abilitiesMakeupArray addObject:TEUI_BEAUTY_MAKEUP];
        [self.abilitiesMakeupArray addObject:TEUI_LIGHT_MAKEUP];
    }
    return array;
}

- (NSMutableArray<TEUIProperty *> *)getAbilitiesMotionData:(NSString *)comboType {
    [self clearMotionLutData];
    [self getLightMotionData];
    [self getMotion2dData];
    [self getMotion3dData];
    [self getMakeupData];
    [self getMotionGestureData];
    [self getSegmentationData];
    [self getMotionCameraMoveData];
    NSMutableArray<TEUIProperty *> *array = [NSMutableArray array];
    self.abilitiesMotionArray = [NSMutableArray array];
    
    if ([comboType isEqualToString:@"A1-02"] ||
       [comboType isEqualToString:@"A1-03"]) {
        [array addObjectsFromArray:@[self.lightMotionData,self.motion2dData,self.motionCameraMoveData]];
        [self.abilitiesMotionArray addObjectsFromArray:@[TEUI_LIGHT_MOTION,TEUI_MOTION_2D,TEUI_MOTION_CAMERA_MOVE]];
    } else if ([comboType isEqualToString:@"A1-04"]) {
        [array addObjectsFromArray:@[self.lightMotionData,self.motion2dData,self.motionGestureData,self.motionCameraMoveData]];
        [self.abilitiesMotionArray addObjectsFromArray:@[TEUI_LIGHT_MOTION,TEUI_MOTION_2D,TEUI_MOTION_GESTURE,TEUI_MOTION_CAMERA_MOVE]];
    } else if ([comboType isEqualToString:@"A1-05"] ||
             [comboType isEqualToString:@"S1-03"]) {
        [array addObjectsFromArray:@[self.lightMotionData,self.motion2dData,self.motion3dData,self.segmentationData,self.motionCameraMoveData]];
        [self.abilitiesMotionArray addObjectsFromArray:@[TEUI_LIGHT_MOTION,TEUI_MOTION_2D,TEUI_MOTION_3D,TEUI_SEGMENTATION,TEUI_MOTION_CAMERA_MOVE]];
    } else if ([comboType isEqualToString:@"A1-06"] ||
             [comboType isEqualToString:@"S1-01"]) {
        [array addObjectsFromArray:@[self.lightMotionData,self.motion2dData,self.motion3dData,self.makeupData,self.motionCameraMoveData]];
        [self.abilitiesMotionArray addObjectsFromArray:@[TEUI_LIGHT_MOTION,TEUI_MOTION_2D,TEUI_MOTION_3D,TEUI_MAKEUP,TEUI_MOTION_CAMERA_MOVE]];
    } else if ([comboType isEqualToString:@"S1-02"]) {
        [array addObjectsFromArray:@[self.lightMotionData,self.motion2dData,self.motion3dData,self.makeupData,self.motionGestureData,self.motionCameraMoveData]];
        [self.abilitiesMotionArray addObjectsFromArray:@[TEUI_LIGHT_MOTION,TEUI_MOTION_2D,TEUI_MOTION_3D,TEUI_MAKEUP,TEUI_MOTION_GESTURE,TEUI_MOTION_CAMERA_MOVE]];
    }else{
        [array addObjectsFromArray:@[self.lightMotionData,self.motion2dData,self.motion3dData,self.makeupData,self.motionGestureData,self.segmentationData,self.motionCameraMoveData]];
        [self.abilitiesMotionArray addObjectsFromArray:@[TEUI_LIGHT_MOTION,TEUI_MOTION_2D,TEUI_MOTION_3D,TEUI_MAKEUP,TEUI_MOTION_GESTURE,TEUI_SEGMENTATION,TEUI_MOTION_CAMERA_MOVE]];
    }
    return array;
}

- (NSMutableArray<TEUIProperty *> *)getAbilitiesTemplateData:(NSString *)comboType {
    [self getBeautyTemplateData];
    [self getMakeupData];
    NSMutableArray<TEUIProperty *> *array = [NSMutableArray array];
    self.abilitiesTemplateArray = [NSMutableArray array];
    
    [array addObject:self.beautyTemplateData];
    [array addObject:self.makeupData];
    [self.abilitiesTemplateArray addObject:TEUI_BEAUTY_TEMPLATE];
    [self.abilitiesTemplateArray addObject:TEUI_MAKEUP];
    return array;
}

- (NSMutableArray<TEUIProperty *> *)getAbilitiesTemplateBeautyData {
    [self getTemplateBeautyData];
    [self getTemplateBeautyImageData];
    [self getTemplateBeautyShapeData];
    [self getTemplateBeautyMakeupData];
    NSMutableArray<TEUIProperty *> *array = [NSMutableArray array];
    [array addObjectsFromArray:@[self.templateBeautyData,self.templateBeautyImageData,self.templateBeautyShapeData,self.templateBeautyMakeupData]];
    
    if (!self.abilitiesTemplateBeautyArray) {
        self.abilitiesTemplateBeautyArray = [NSMutableArray array];
    }
    [self.abilitiesTemplateBeautyArray addObjectsFromArray:@[TEUI_BEAUTY,TEUI_BEAUTY_IMAGE,TEUI_BEAUTY_SHAPE,TEUI_BEAUTY_MAKEUP]];
    return array;
    
}

- (void)clearData {
    _beautyTemplateData = nil;
    _templateBeautyData = nil;
    _templateBeautyImageData = nil;
    _templateBeautyShapeData = nil;
    _templateBeautyMakeupData = nil;
    
    _beautyTemplatePanelData = nil;
    _beautyPanelData = nil;
    _beautyShapePanelData = nil;
    _beautyImagePanelData = nil;
    _beautyMakeupPanelData = nil;
    _lightMakeupPanelData = nil;
    _lutPanelData = nil;
    _beautyBodyPanelData = nil;
    _motionPanelData = nil;
    _lightMotionPanelData = nil;
    _motion2dPanelData = nil;
    _motion3dPanelData = nil;
    _makeupPanelData = nil;
    _segmentationPanelData = nil;
    
    [self clearMotionLutData];
}

- (void)clearMotionLutData {
    _beautyBaseShapeData = nil;
    _beautyBodyData = nil;
    _beautyGeneralShapeData = nil;
    _beautyImageData = nil;
    _beautyMakeupData = nil;
    _beautyShapeData = nil;
    _beautyData = nil;
    _makeupData = nil;
    _lightMakeupData = nil;
    _segmentationData = nil;
    _lutData = nil;
    _motionData = nil;
    _lightMotionData = nil;
    _motion2dData = nil;
    _motion3dData = nil;
    _motionGestureData = nil;
    _motionCameraMoveData = nil;
    _portraitSegmentationData = nil;
    _segmentationData = nil;
}

- (NSArray<NSString *> *)motionOfCombos {
    if (!_motionOfCombos) {
        _motionOfCombos = @[@"A1-02",@"A1-03",@"A1-05",@"A1-06",
                            @"S1-01",@"S1-02",@"S1-03",@"S1-04",@"S1-07"];
    }
    return _motionOfCombos;
}

- (NSArray<NSString *> *)makeupOfCombos {
    if (!_makeupOfCombos) {
        _makeupOfCombos = @[@"A1-06",@"S1-00",@"S1-01",@"S1-02",@"S1-03",@"S1-04",@"S1-07"];
    }
    return _makeupOfCombos;
}

- (NSArray<NSArray<NSString *> *> *)exclusionGroup {
    if (!_exclusionGroup) {
        _exclusionGroup = @
        [@[BEAUTY_WHITEN0,BEAUTY_WHITEN,BEAUTY_WHITEN2,BEAUTY_WHITEN3],
         @[BEAUTY_BLACK1,BEAUTY_BLACK2],
         @[BEAUTY_SMOOTH,BEAUTY_SMOOTH2,BEAUTY_SMOOTH3,BEAUTY_SMOOTH4],
         @[BEAUTY_FACE_NATURE,BEAUTY_FACE_GODNESS,BEAUTY_FACE_MALE_GOD]];
    }
    return _exclusionGroup;
}

- (NSArray<NSString *> *)beautyMakeupNoneGroup {
    if (!_beautyMakeupNoneGroup) {
        _beautyMakeupNoneGroup = @
        [BEAUTY_MOUTH_LIPSTICK,BEAUTY_FACE_RED_CHEEK,BEAUTY_HAIR_COLOR_LUT,
         BEAUTY_FACE_EYE_SHADOW,BEAUTY_FACE_EYE_LINER,BEAUTY_FACE_EYELASH,
         BEAUTY_FACE_EYELIDS,BEAUTY_FACE_EYEWOCAN,BEAUTY_FACE_EYEBALL,
         BEAUTY_FACE_EYEBROW,BEAUTY_FACE_SOFTLIGHT];
    }
    return _beautyMakeupNoneGroup;
}

- (NSMutableDictionary *)enhancedMultipleDictionary {
    if (!_enhancedMultipleDictionary) {
        _enhancedMultipleDictionary = [NSMutableDictionary dictionaryWithDictionary:@{
            BEAUTY_FACE_REMOVE_WRINKLE : @(1.3),
            BEAUTY_FACE_REMOVE_LAW_LINE : @(1.3),
            BEAUTY_FACE_SKIN_RETOUCH : @(1.3),
            BEAUTY_MOUTH_LIPSTICK : @(1.3),
            BEAUTY_WHITEN : @(1.3),
            BEAUTY_FACE_SOFTLIGHT : @(1.3),
            BEAUTY_FACE_SHORT : @(1.3),
            BEAUTY_FACE_V : @(1.3),
            BEAUTY_EYE_DISTANCE : @(1.3),
            BEAUTY_NOSE_HEIGHT : @(1.3),
            BEAUTY_EYE_LIGHTEN : @(1.5),
            BEAUTY_FACE_RED_CHEEK : @(1.8)
        }];
    }
    return _enhancedMultipleDictionary;
}

- (void)setEnhancedMultiple:(NSMutableDictionary *)enhancedMultiple {
    [enhancedMultiple enumerateKeysAndObjectsUsingBlock:^(id  _Nonnull key, id  _Nonnull obj, BOOL * _Nonnull stop) {
        _enhancedMultipleDictionary[key] = obj;
    }];
}

- (NSDictionary *)readLocalFileWithName:(NSString *)name {
    NSString *path = [[NSBundle mainBundle] pathForResource:name ofType:@"json"];
    if (![[NSFileManager defaultManager] fileExistsAtPath:path]) {
        return nil;
    }
    NSData *data = [[NSData alloc] initWithContentsOfFile:path];
    return [NSJSONSerialization JSONObjectWithData:data options:kNilOptions error:nil];
}

- (NSDictionary *)readLocalFileWithPath:(NSString *)path {
//    NSString *path = [[NSBundle mainBundle] pathForResource:name ofType:@"json"];
    if (![[NSFileManager defaultManager] fileExistsAtPath:path]) {
        NSLog(@"path:%@ is not exists",path);
        return nil;
    }
    NSData *data = [[NSData alloc] initWithContentsOfFile:path];
    return [NSJSONSerialization JSONObjectWithData:data options:kNilOptions error:nil];
}
@end
