//
//  TEUIConfig.h
//  BeautyDemo
//
//  Created by tao yue on 2024/1/21.
//

#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>

NS_ASSUME_NONNULL_BEGIN

@interface TEUIConfig : NSObject
/// 美颜面板背景色
@property (nonatomic, strong) UIColor *panelBackgroundColor;
/// 分割线颜色
@property (nonatomic, strong) UIColor *panelDividerColor;
/// 选中项颜色
@property (nonatomic, strong) UIColor *panelItemCheckedColor;
/// 文本颜色
@property (nonatomic, strong) UIColor *textColor;
/// 文本选中颜色
@property (nonatomic, strong) UIColor *textCheckedColor;
/// 进度条颜色
@property (nonatomic, strong) UIColor *seekBarProgressColor;
/// 单例
+ (instancetype)shareInstance;
/// 设置面板资源路径
/// - Parameter resources: 资源路径列表
/// e.g. @[@{TEUI_BEAUTY : @"json file path"}]
- (void)setTEPanelViewResources:(NSArray<NSDictionary *> *)resources;
/// 获取面板资源路径
- (NSArray<NSDictionary *> *)getTEPanelViewResources;
/// 美颜模板
- (NSString *)getBeautyTemplatePath;
/// 美颜
- (NSString *)getBeautyPath;
/// 美型
- (NSString *)getBeautyShapePath;
/// 画质
- (NSString *)getBeautyImagePath;
/// 美妆
- (NSString *)getBeautyMakeupPath;
/// 轻美妆
- (NSString *)getLightMakeupPath;
/// 滤镜
- (NSString *)getLutPath;
/// 美体
- (NSString *)getBeautyBodyPath;
/// 动效贴纸
- (NSString *)getMotionPath;
/// 轻贴纸
- (NSString *)getLightMotionPath;
/// 2d贴纸
- (NSString *)getMotion2dPath;
/// 3d贴纸
- (NSString *)getMotion3dPath;
/// 手势贴纸
- (NSString *)getMotionHandPath;
/// 整妆
- (NSString *)getMakeupPath;
/// 分割
- (NSString *)getSegmentationPath;
/// 加载图片
/// - Parameter name: 名称
- (UIImage *)imageNamed:(NSString *)name;
/// 加载本地化字符串
/// - Parameter key: 键值
- (NSString *)localizedString:(NSString *)key;
@end

NS_ASSUME_NONNULL_END
