//
//  TEUIConfig.m
//  BeautyDemo
//
//  Created by tao yue on 2024/1/21.
//

#import "TEUIConfig.h"
#import "TEUIDefine.h"

@interface TEUIConfig()

@property (nonatomic, copy) NSString *lightCoreBundlePath;
@property (nonatomic, copy) NSString *beautyTemplatePath; //美颜模板json路径
@property (nonatomic, copy) NSString *beautyPath; //美颜json路径
@property (nonatomic, copy) NSString *beautyShapePath; //高级美型json路径
@property (nonatomic, copy) NSString *beautyImagePath; //画质调整json路径
@property (nonatomic, copy) NSString *beautyMakeupPath;  //单点美妆json路径
@property (nonatomic, copy) NSString *lightMakeupPath;  //轻美妆json路径
@property (nonatomic, copy) NSString *lutPath;  //滤镜json路径
@property (nonatomic, copy) NSString *beautyBodyPath; //美体json路径
@property (nonatomic, copy) NSString *motionPath;  //贴纸json路径
@property (nonatomic, copy) NSString *lightMotionPath;  //轻贴纸json路径
@property (nonatomic, copy) NSString *motion2dPath;  //2D贴纸json路径
@property (nonatomic, copy) NSString *motion3dPath;  //3D贴纸json路径
@property (nonatomic, copy) NSString *motionHandPath;   //手势贴纸路径
@property (nonatomic, copy) NSString *makeupPath;   //风格整装json路径
@property (nonatomic, copy) NSString *segmentationPath;   //背景分割json路径
@property (nonatomic, copy) NSString *resourcePath;
@property (nonatomic, strong) NSArray<NSDictionary *> *resources;
@property (nonatomic, strong) NSBundle *resourceBundle;

@end

@implementation TEUIConfig

+ (instancetype)shareInstance {
    static TEUIConfig *teUIConfig;
    static dispatch_once_t onceToken;
    dispatch_once(&onceToken, ^{
        if (teUIConfig == nil) {
            teUIConfig = [[TEUIConfig alloc] init];
        }
    });
    return teUIConfig;
}

- (instancetype)init {
    if (self = [super init]) {
        _resourcePath = [[NSBundle mainBundle] pathForResource:@"TEBeautyKitResources"
                                                                 ofType:@"bundle"];
        _resourceBundle = [NSBundle bundleWithPath:self.resourcePath];
    }
    return self;
}

- (NSString *)localizedString:(NSString *)key {
    if (_resourceBundle == nil) {
        return [[NSBundle mainBundle] localizedStringForKey:key value:@"" table:nil];
    }
    NSString *language = [[NSLocale preferredLanguages] firstObject];
    if ([language hasPrefix:@"zh"]) {
        language = @"zh-Hans";
    }else {
        language = @"en";
    }
    NSBundle *languageBundle = [NSBundle bundleWithPath:[_resourceBundle pathForResource:language ofType:@"lproj"]];
    return [languageBundle localizedStringForKey:key value:@"" table:nil];
}

- (UIImage *)imageNamed:(NSString *)name {
    UIImage *image = nil;
    // 优先从 resourceBundle (TEBeautyKitResources.bundle) 加载
    if (_resourceBundle) {
        image = [UIImage imageNamed:name inBundle:_resourceBundle compatibleWithTraitCollection:nil];
    }
    // 如果 resourceBundle 中没有找到，尝试从 Pod 的 bundle 加载
    if (!image) {
        NSBundle *podBundle = [NSBundle bundleForClass:[self class]];
        image = [UIImage imageNamed:name inBundle:podBundle compatibleWithTraitCollection:nil];
    }
    // 最后尝试从 mainBundle 加载
    if (!image) {
        image = [UIImage imageNamed:name inBundle:[NSBundle mainBundle] compatibleWithTraitCollection:nil];
    }
    return image;
}

- (void)setTEPanelViewResources:(NSArray<NSDictionary *> *)resources {
    _resources = resources;
    NSMutableDictionary *resDic = [[NSMutableDictionary alloc] init];
    for (NSDictionary *dic in resources) {
        [resDic addEntriesFromDictionary:dic];
    }
    _beautyTemplatePath = resDic[TEUI_BEAUTY_TEMPLATE];
    _beautyPath = resDic[TEUI_BEAUTY];
    _beautyShapePath = resDic[TEUI_BEAUTY_SHAPE];
    _beautyImagePath = resDic[TEUI_BEAUTY_IMAGE];
    _beautyMakeupPath = resDic[TEUI_BEAUTY_MAKEUP];
    _lightMakeupPath = resDic[TEUI_LIGHT_MAKEUP];
    _lutPath = resDic[TEUI_LUT];
    _beautyBodyPath = resDic[TEUI_BEAUTY_BODY];
    _motionPath = resDic[TEUI_MOTION];
    _lightMotionPath = resDic[TEUI_LIGHT_MOTION];
    _motion2dPath = resDic[TEUI_MOTION_2D];
    _motion3dPath = resDic[TEUI_MOTION_3D];
    _motionHandPath = resDic[TEUI_MOTION_GESTURE];
    _makeupPath = resDic[TEUI_MAKEUP];
    _segmentationPath = resDic[TEUI_SEGMENTATION];
}

- (NSArray<NSDictionary *> *)getTEPanelViewResources {
    return _resources;
}

- (NSString *)getBeautyTemplatePath {
    return _beautyTemplatePath;
}

- (NSString *)getBeautyPath {
    return _beautyPath;
}

- (NSString *)getBeautyShapePath {
    return _beautyShapePath;
}

- (NSString *)getBeautyImagePath {
    return _beautyImagePath;
}

- (NSString *)getBeautyMakeupPath {
    return _beautyMakeupPath;
}

- (NSString *)getLightMakeupPath {
    return _lightMakeupPath;
}

- (NSString *)getLutPath {
    return _lutPath;
}

- (NSString *)getBeautyBodyPath {
    return _beautyBodyPath;
}

- (NSString *)getMotionPath {
    return _motionPath;
}

- (NSString *)getLightMotionPath {
    return _lightMotionPath;
}

- (NSString *)getMotion2dPath {
    return _motion2dPath;
}

- (NSString *)getMotion3dPath {
    return _motion3dPath;
}

- (NSString *)getMotionHandPath {
    return _motionHandPath;
}

- (NSString *)getMakeupPath {
    return _makeupPath;
}

- (NSString *)getSegmentationPath {
    return _segmentationPath;
}

- (UIColor *)panelBackgroundColor {
    if(!_panelBackgroundColor){
        _panelBackgroundColor = [UIColor colorWithRed:0 green:0 blue:0 alpha:0.75];
    }
    return _panelBackgroundColor;
}
- (UIColor *)panelDividerColor {
    if(!_panelDividerColor){
        _panelDividerColor = [UIColor colorWithWhite:1 alpha:0.1];
    }
    return _panelDividerColor;
}

- (UIColor *)panelItemCheckedColor {
    if(!_panelItemCheckedColor){
        _panelItemCheckedColor = [UIColor colorWithRed:0 green:0.424 blue:1 alpha:1];
    }
    return _panelItemCheckedColor;
}

- (UIColor *)textColor {
    if(!_textColor){
        _textColor = [UIColor whiteColor];
    }
    return _textColor;
}

- (UIColor *)textCheckedColor {
    if(!_textCheckedColor){
        _textCheckedColor = [UIColor whiteColor];
    }
    return _textCheckedColor;
}

- (UIColor *)seekBarProgressColor {
    if(!_seekBarProgressColor){
        _seekBarProgressColor = [UIColor colorWithRed:0 green:0x6e/255.0 blue:1 alpha:1];
    }
    return _seekBarProgressColor;
}


@end
