//
//  TESliderValueCalculator.m
//  Tencent-Effect-Demo
//
//  Created by wwk on 2025/8/12.
//

#import "TESliderValueCalculator.h"
#import "TEUIDefine.h"

@implementation TESliderValueCalculator
+ (float)minValueForSliderWithModel:(TEUIProperty *)model{
    NSString *abilityType = model.abilityType;
    NSString *effectName = model.sdkParam.effectName;
    
    NSDictionary *minValueRules = @{
        TEUI_BEAUTY: @0, //美颜
        TEUI_BEAUTY_MAKEUP: @0,  //单点美妆
        
        TEUI_BEAUTY_IMAGE: @{   //画质调整
            @"beauty.imageContrastAlpha": @-100,//对比度
            @"smooth.saturation": @-100,//饱和度
            @"beauty.imageBrightness": @-100,//亮度
            @"beauty.imageWarmth": @-100,//色温
            @"beauty.imageTint": @-100 //色调
        },
        
        // 高级美型：仅配置需返回0的例外项，其余默认返回-100
        TEUI_BEAUTY_SHAPE: [NSSet setWithArray:@[
            @"basicV7.enlargeEye",//大眼
            @"beauty.eyeLighten",//亮眼
            @"beauty.removeEyeBags",//祛眼袋
            @"basicV7.thinNose",//瘦鼻
            @"beauty.toothWhiten",//白牙
            @"basicV7.thinFace",//窄脸
            @"basicV7.natureFace",//瘦脸-自然
            @"basicV7.godnessFace",//瘦脸-女神
            @"basicV7.maleGodFace",//瘦脸-英俊
            @"basicV7.vFace",//V脸
            @"basicV7.faceJaw",//收下颌
            @"basicV7.shortFace",//短脸
            @"liquefaction.basic3",//脸型
            @"beauty.removeWrinkle",//祛皱
            @"beauty.removeLawLine",//祛法令纹
            @"basicV7.cheekboneThin",//瘦颧骨
        ]],
        
        TEUI_BEAUTY_BODY: @{  //美体
            @"body.enlargeChestStrength": @-100,//胸部调整
            @"body.slimArmStrength": @-100 //瘦胳膊
        },
        
        TEUI_SEGMENTATION : @{ //绿幕v2
            @"green_background_v2.smooth" : @1 //平滑度
        }
    };
    
    id rule = minValueRules[abilityType];
    
    // 情况1：直接返回固定值（NSNumber类型）
    if ([rule isKindOfClass:NSNumber.class]) {
        return [rule floatValue];
    }
    
    // 情况2：处理字典配置（如画质调整、美体）
    if ([rule isKindOfClass:NSDictionary.class]) {
        NSNumber *value = rule[effectName];
        return value ? value.floatValue : 0; // 未匹配时返回0
    }
    
    // 情况3：处理高级美型（NSSet类型）
    if ([rule isKindOfClass:NSSet.class]) {
        NSSet *exceptions = (NSSet *)rule;
        // 当前特效在例外集合中 → 返回0，否则返回-100
        return [exceptions containsObject:effectName] ? 0 : -100;
    }
    
    return 0; // 默认值
}

+ (float)maxValueForSliderWithModel:(TEUIProperty *)model {
    NSString *abilityType = model.abilityType;
    NSString *effectName = model.sdkParam.effectName;
    NSDictionary *maxValueRules = @{
        TEUI_SEGMENTATION : @{ //绿幕v2
            @"green_background_v2.corrosion" : @3, //边缘消除强度
            @"green_background_v2.deshadow" : @5   //去阴影
        }
    };
    id rule = maxValueRules[abilityType];
    if ([rule isKindOfClass:[NSDictionary class]]) {
        NSNumber *value = rule[effectName];
        return value ? value.floatValue : 100;
    }
    return 100;
}

@end
