//
//  TEPanelView.h
//  TEBeautyKit
//
//  Created by tao yue on 2024/1/9.
//

#import <UIKit/UIKit.h>
#import <XMagic/XMagic.h>
#import "TEBeautyKit.h"
#import "TEUIDefine.h"

@protocol TEPanelViewDelegate <NSObject>
@optional
/// 展示美颜效果，点击对比按钮是回调
- (void)showBeautyChanged:(BOOL)open;
/// 设置了美颜效果
- (void)setEffect;
/// 选中的效果
- (void)selectEffect:(TEUIProperty *)property;
/// 点击了自定义背景
- (void)onCustomSegBtnClick;
/// 点击了绿幕
- (void)onGreenscreenItemClick;

@end

@interface TEPanelView : UIView
/// 美颜SDK对象
@property (nonatomic, weak) XMagic *beautyKitApi;
/// beautyKit对象
@property (nonatomic, strong) TEBeautyKit *teBeautyKit;
/// 代理
@property (nonatomic, weak) id<TEPanelViewDelegate> delegate;
/// 设置导出的美颜数据
- (void)setExportParamList:(NSString *)lastParamList;
/// 默认美颜
- (void)setDefaultBeauty;
/// 重置所有效果
- (void)performFullReset;
/// TODO
- (int)handleMediaAtPath:(NSString *)path;
/// 增强模式
- (void)setEnhancedMode:(BOOL)enhancedMode;
/// 显示对比按钮
- (void)isShowCompareBtn:(BOOL)isShow;

@end
