//
//  TETabCollectionViewCell.m
//  TEBeautyKit
//
//  Created by jasonggao on 2025/10/23.
//

#import "TETabCollectionViewCell.h"
#import <Masonry/Masonry.h>

@interface TETabCollectionViewCell ()
@property (nonatomic, strong, readwrite) UILabel *titleLabel;

@end

@implementation TETabCollectionViewCell

- (instancetype)initWithFrame:(CGRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        [self setupUI];
    }
    return self;
}

- (void)setupUI {
    self.titleLabel = [[UILabel alloc] init];
    self.titleLabel.textColor = [UIColor whiteColor];
    self.titleLabel.font = [UIFont systemFontOfSize:16];
    self.titleLabel.textAlignment = NSTextAlignmentCenter;
    [self.contentView addSubview:self.titleLabel];
    [self.titleLabel mas_makeConstraints:^(MASConstraintMaker *make) {
        make.edges.offset(0);
    }];
}

@end
