package com.tencent.ugcupload.demo;

import android.app.Activity;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.TextView;

import androidx.core.app.ActivityCompat;

import com.tencent.ugcupload.demo.utils.VideoServerManager;
import com.tencent.ugcupload.videoupload.TXUGCPublish;
import com.tencent.ugcupload.videoupload.TXUGCPublishTypeDef;
import com.tencent.ugcupload.videoupload.impl.TVCNetWorkStateReceiver;
import com.tencent.ugcupload.videoupload.impl.UploadResumeDefaultController;

public class MainActivity extends Activity implements View.OnClickListener,
        TXUGCPublishTypeDef.ITXVideoPublishListener {

    private static final String TAG = MainActivity.class.getName();
    public static final int REQUESTCODE = 1;
    private static final int REQUEST_EXTERNAL_STORAGE = 1;
    private static String[] PERMISSIONS_STORAGE = {
            "android.permission.READ_EXTERNAL_STORAGE",
            "android.permission.WRITE_EXTERNAL_STORAGE"};
    private TextView mResultMsg;
    private ProgressBar mProgress;
    private String mVideoPath;
    private TXUGCPublish mVideoPublish = null;
    // signature计算规则可参考 https://www.qcloud.com/document/product/266/9221
    private String mSignature = "";
    private EditText mEtUploadKey;
    private TVCNetWorkStateReceiver mNetWorkStateReceiver;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        if ((getIntent().getFlags() & Intent.FLAG_ACTIVITY_BROUGHT_TO_FRONT) != 0) {
            Log.d(TAG, "brought to front");
            finish();
            return;
        }

        setContentView(R.layout.activity_main);
        mResultMsg = (TextView) findViewById(R.id.resultMsg);
        mProgress = (ProgressBar) findViewById(R.id.progressBar);
        mEtUploadKey = findViewById(R.id.et_upload_key);
        registerNetReceiver();
        VideoServerManager.getInstance().setPublishSigListener(new VideoServerManager.PublishSigListener() {
            @Override
            public void onSuccess(String signatureStr) {
                mSignature = signatureStr;
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        beginUpload();
                    }
                });
            }

            @Override
            public void onFail(int errCode) {

            }
        });
    }


    public boolean verifyStoragePermissions() {
        try {
            int permission = ActivityCompat.checkSelfPermission(this,
                    "android.permission.WRITE_EXTERNAL_STORAGE");
            if (permission != PackageManager.PERMISSION_GRANTED) {
                ActivityCompat.requestPermissions(this, PERMISSIONS_STORAGE, REQUEST_EXTERNAL_STORAGE);
                return false;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public void onClick(View view) {
//        if (TextUtils.isEmpty(mSignature)) {
//            // more information about signature,refer to https://www.qcloud.com/document/product/266/9221
//            Toast.makeText(view.getContext(), "Please fill in the signature (mSignature is null.)", Toast
//            .LENGTH_SHORT).show();
//            return;
//        }
        switch (view.getId()) {
            case R.id.choose_file:
                if (verifyStoragePermissions()) ;
                chooseFile();
                break;
            case R.id.upload:
//                copyVideoToLocal(mVideoPath);
                VideoServerManager.getInstance().getPublishSig();
//                beginUpload();
                break;
            case R.id.pause:
                pauseUpload();
                break;
            default:
                break;
        }
    }

    private void pauseUpload() {
        if (mVideoPublish != null) {
            mVideoPublish.canclePublish();
        }
    }

    private void beginUpload() {
        mResultMsg.setText("");
        mProgress.setProgress(0);
        String uploadKey = mEtUploadKey.getText().toString();
        mVideoPublish = new TXUGCPublish(getApplicationContext(), "", uploadKey);
        mVideoPublish.setListener(this);

        TXUGCPublishTypeDef.TXPublishParam param = new TXUGCPublishTypeDef.TXPublishParam();
        param.signature = mSignature;
        param.videoPath = mVideoPath;
        param.fileName = "test";
        param.uploadResumeController = new UploadResumeDefaultController(this);
        int publishCode = mVideoPublish.publishVideo(param);
        if (publishCode != 0) {
            mResultMsg.setText("Publish failed, error code:" + publishCode);
        }

    }

    private void chooseFile() {
        Intent intent = new Intent(Intent.ACTION_GET_CONTENT);
        intent.setType("video/*");
        intent.addCategory(Intent.CATEGORY_OPENABLE);
        Intent wrapIntent = Intent.createChooser(intent, null);
        startActivityForResult(wrapIntent, REQUESTCODE);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == REQUESTCODE) {
            if (resultCode == RESULT_OK) {
                Uri uri = data.getData();
                Log.d(TAG, "File Uri: " + uri.toString());
                // Get the path
                String path = null;
                path = FileUtils.getRealPathFromUri(this, uri);
                mVideoPath = path;
                Log.d(TAG, "File Path: " + path);
            }
        }
    }

    @Override
    public void onPublishProgress(long uploadBytes, long totalBytes) {
        Log.i(TAG, "onPublishProgress:" + uploadBytes + "/" + totalBytes);
        mProgress.setProgress((int) (100 * uploadBytes / totalBytes));
    }

    @Override
    public void onPublishComplete(TXUGCPublishTypeDef.TXPublishResult result) {
        Log.i(TAG, "onPublishComplete!");
        mResultMsg.setText(result.retCode + " Msg:" + (result.retCode == 0 ? result.videoURL : result.descMsg));
    }

    private void registerNetReceiver() {
        if (null == mNetWorkStateReceiver) {
            mNetWorkStateReceiver = new TVCNetWorkStateReceiver();
            IntentFilter intentFilter = new IntentFilter(ConnectivityManager.CONNECTIVITY_ACTION);
            registerReceiver(mNetWorkStateReceiver, intentFilter);
        }
    }

    private void unRegisterNetReceiver() {
        if (null != mNetWorkStateReceiver) {
            unregisterReceiver(mNetWorkStateReceiver);
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        unRegisterNetReceiver();
    }
}
