//
//  LIBTXVODViewController.m
//  TXVodUpload
//
//  Copyright (c) 2024 tencent. All rights reserved.
//

#import "LIBTXVODViewController.h"
#import <MobileCoreServices/MobileCoreServices.h>
#import <Photos/Photos.h>
#import <TXVodUpload/TXUGCPublish.h>
#import <TXVodUpload/TXUGCPublishOptCenter.h>
#import "TCHttpUtil.h"
#import <TXVodUpload/UploadResumeDefaultController.h>

@interface LIBTXVODViewController ()<UINavigationControllerDelegate, UIImagePickerControllerDelegate>
@property (nonatomic, strong) NSString* uploadTempFilePath;
@property (nonatomic, strong) NSString* sessionFileKey;

@end

@implementation LIBTXVODViewController
{
    TXUGCPublish     *_videoPublish;
    NSString         *_signature;
}

typedef void(^ResultPath)(NSString *filePath, NSString *fileName);

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
}

- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
    [self.progressView setProgress:0.0f animated:NO];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (IBAction)selectImage{
    UIImagePickerController *picker = [[UIImagePickerController alloc] init];
    NSString *requiredMediaType1 = ( NSString *)kUTTypeMovie;
    picker.sourceType = UIImagePickerControllerSourceTypePhotoLibrary;
    NSArray *arrMediaTypes=[NSArray arrayWithObjects:requiredMediaType1,nil];
    [picker setMediaTypes: arrMediaTypes];
    picker.delegate = self;
    [self presentViewController:picker animated:YES completion:nil];
}

- (void)imagePickerControllerDidCancel:(UIImagePickerController *)picker {
    [picker dismissViewControllerAnimated:YES completion:nil];
}

- (void)imagePickerController:(UIImagePickerController *)picker didFinishPickingMediaWithInfo:(NSDictionary<NSString*, id> *)info {
    NSURL *assetUrl = [info objectForKey:UIImagePickerControllerReferenceURL];
    PHFetchResult *fetchResult = [PHAsset fetchAssetsWithALAssetURLs:@[assetUrl] options:nil];
    PHAsset *asset = fetchResult.firstObject;
    
    [self getVideoPathFromPHAsset:asset Complete:^(NSString *filePath, NSString *fileName) {
        NSLog(@"filePath:%@",filePath);
        [self copyVideoToLocal:fileName withInput:filePath];
    }];
    [picker dismissViewControllerAnimated:NO completion:^{

    }];
}

- (void)getVideoPathFromPHAsset:(PHAsset *)asset Complete:(ResultPath)result {
    NSArray *assetResources = [PHAssetResource assetResourcesForAsset:asset];
    PHAssetResource *resource;
    for (PHAssetResource *assetRes in assetResources) {
        if (assetRes.type == PHAssetResourceTypePairedVideo || assetRes.type == PHAssetResourceTypeVideo) {
            resource = assetRes;
        }
    }
    NSString *fileName = @"tempAssetVideo.mov";
    if (resource.originalFilename) {
        fileName = resource.originalFilename;
    }
    if (asset.mediaType == PHAssetMediaTypeVideo || asset.mediaSubtypes == PHAssetMediaSubtypePhotoLive) {
        PHVideoRequestOptions *options = [[PHVideoRequestOptions alloc] init];
        options.version = PHImageRequestOptionsVersionCurrent;
        options.deliveryMode = PHImageRequestOptionsDeliveryModeHighQualityFormat;
        NSString *PATH_MOVIE_FILE = [NSTemporaryDirectory() stringByAppendingPathComponent:fileName];
        [[NSFileManager defaultManager] removeItemAtPath:PATH_MOVIE_FILE error:nil];
        [[PHAssetResourceManager defaultManager] writeDataForAssetResource:resource                                                                    toFile:[NSURL fileURLWithPath:PATH_MOVIE_FILE]                                                                   options:nil                                                         completionHandler:^(NSError * _Nullable error) {
            if (error) {
                result(nil, nil);
            } else {
                result(PATH_MOVIE_FILE, fileName);
            }
        }];
    } else {
        result(nil, nil);
    }
}

- (void)copyVideoToLocal:(NSString*)fileName withInput:(NSString*)sourceUrl
{
    if(!sourceUrl || !fileName) {
        return;
    }
    NSFileManager *manager = [NSFileManager defaultManager];
    NSString* tempPath = [self TempFilePathWithExtension:@"mov" withName:fileName];
    if([manager fileExistsAtPath:tempPath] && [manager isReadableFileAtPath:tempPath] && [[manager attributesOfItemAtPath:tempPath error:nil] fileSize] > 0) {
        NSLog(@"file already exists, jump video copy");
        self.uploadTempFilePath = tempPath;
        [self videoTransSuc];
    } else {
        [manager removeItemAtPath:tempPath error:nil];
        NSURL *tempUrl = [NSURL URLWithString:tempPath];
        NSError *error;
        [manager copyItemAtPath:sourceUrl toPath:tempPath error:&error];
        if (error){
            NSLog(@"Failed to save file to cache");
            [self videoTransFailed];
        } else {
            self.uploadTempFilePath = tempPath;
            [self videoTransSuc];
        }
    }
}

- (void)convertVideoQuailtyWithInputURL:(NSURL*)inputURL
                               withName:(NSString*)name
                         completeHandler:(void (^)(AVAssetExportSession*))handler {
    [self.resultTextView setText:@"视频转码中 Video transcoding......"];
    NSString* tempPath = [self TempFilePathWithExtension:@"mp4" withName:name];
    NSURL *outputURL = [NSURL fileURLWithPath:tempPath];
    NSFileManager *manager = [NSFileManager defaultManager];
    if([manager fileExistsAtPath:tempPath] && [manager isReadableFileAtPath:tempPath] && [[manager attributesOfItemAtPath:tempPath error:nil] fileSize] > 0) {
        NSLog(@"file already exists, jump video convert");
        self.uploadTempFilePath = [outputURL path];
        [self.uploadLabel setEnabled:true];
        [self.resultTextView setText:@"Video format transcoded successfully, you can click to start uploading.视频格式转码成功，可以点击开始上传"];
    } else {
        AVURLAsset *avAsset = [AVURLAsset URLAssetWithURL:inputURL options:nil];
        AVAssetExportSession *exportSession = [[AVAssetExportSession alloc] initWithAsset:avAsset presetName:AVAssetExportPresetMediumQuality];
        exportSession.outputURL = outputURL;
        exportSession.outputFileType = AVFileTypeMPEG4;
        exportSession.shouldOptimizeForNetworkUse= YES;
        [exportSession exportAsynchronouslyWithCompletionHandler:^(void) {
             switch (exportSession.status) {
                 case AVAssetExportSessionStatusCancelled:
                     NSLog(@"AVAssetExportSessionStatusCancelled");
                     break;
                 case AVAssetExportSessionStatusUnknown:
                     NSLog(@"AVAssetExportSessionStatusUnknown");
                     break;
                 case AVAssetExportSessionStatusWaiting:
                     NSLog(@"AVAssetExportSessionStatusWaiting");
                     break;
                 case AVAssetExportSessionStatusExporting:
                     NSLog(@"AVAssetExportSessionStatusExporting");
                     break;
                 case AVAssetExportSessionStatusCompleted:
                     NSLog(@"AVAssetExportSessionStatusCompleted");
                     self.uploadTempFilePath = [outputURL path];
                     [self videoTransSuc];
                     break;
                 case AVAssetExportSessionStatusFailed:
                     NSLog(@"AVAssetExportSessionStatusFailed");
                     [self videoTransFailed];
                     break;
             }
         }];
    }
}

- (NSString*)getAssetIdByQuery:(NSString*)query {
    NSArray *queryArray = [query componentsSeparatedByString:@"&"];
    if(queryArray) {
        for(NSString *queryItem in queryArray) {
            NSArray *queryKeyValue = [queryItem componentsSeparatedByString:@"="];
            if(queryKeyValue.count > 1 && [queryKeyValue[0] isEqual:@"id"]) {
                return queryKeyValue[1];
            }
        }
    }
    return nil;
}

- (void)videoTransSuc {
    dispatch_sync(dispatch_get_main_queue(), ^{
        [self.uploadLabel setEnabled:true];
        [self.resultTextView setText:@"Video pick successfully, you can click to start uploading.视频选择成功，可以点击开始上传"];
    });
}

- (void)videoTransFailed {
    dispatch_sync(dispatch_get_main_queue(), ^{
        [self.uploadLabel setEnabled:true];
        self.uploadTempFilePath = nil;
        [self.resultTextView setText:@"Video copyed failed, please try again.视频拷贝失败，请重试"];
    });
}

- (NSString *)TempFilePathWithExtension:(NSString*)extension withName:fileName {
//    NSString* fileName = [NSUUID UUID].UUIDString;
    NSString* path = NSTemporaryDirectory();
    path = [path stringByAppendingPathComponent:fileName];
    path = [path stringByAppendingPathExtension:extension];
    return path;
}


- (IBAction)beginUpload:(id)sender {
    if (!self.uploadTempFilePath) {
        [self showErrorMessage:@"No file selected!!!没有选择文件！！！"];
        return;
    }
    
    NSString* uploadKeyStr = self.uploadKeyInputView.text;
    _videoPublish = [[TXUGCPublish alloc] initWithUserID:@"independence_ios" withUploadKey:uploadKeyStr];
    _videoPublish.delegate = self;
    [TCHttpUtil asyncSendHttpRequest:@"api/v1/misc/upload/signature" httpServerAddr:kHttpUGCServerAddr HTTPMethod:@"GET" param:nil handler:^(int result, NSDictionary *resultDict) {
        if (result == 0 && resultDict){
            NSDictionary *dataDict = resultDict[@"data"];
            if (dataDict && _videoPublish) {
                _signature =  dataDict[@"signature"];
                
                TXPublishParam *publishParam = [[TXPublishParam alloc] init];
                publishParam.signature  = _signature;
                publishParam.coverPath = nil;
                publishParam.enableHTTPS = YES;
                publishParam.videoPath  = self.uploadTempFilePath;
                publishParam.uploadResumController = [[UploadResumeDefaultController alloc] init];
                
                [_videoPublish publishVideo:publishParam];
                
            }
            
        } else{
            UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"Video upload failed"
                                                                message:[NSString stringWithFormat:@"Error code：%d",result]
                                                               delegate:self
                                                      cancelButtonTitle:@"OK"
                                                      otherButtonTitles:nil, nil];
            [alertView show];
        }
    }];
    
}

- (IBAction)pasueUpload:(id)sender {
    [_videoPublish canclePublish];
}

- (void)showErrorMessage:(NSString*)message {
    self.resultTextView.text = message;
}

#pragma mark - TXVideoPublishListener
- (void)onPublishProgress:(NSInteger)uploadBytes totalBytes:(NSInteger)totalBytes {
    self.progressView.progress = (float)uploadBytes/totalBytes;
    NSLog(@"onPublishProgress [%ld/%ld]", uploadBytes, totalBytes);
}

- (void)onPublishComplete:(TXPublishResult*)result {
    NSString *string = [NSString stringWithFormat:@"Upload completed, error code [%d], information [%@]", result.retCode, result.retCode == 0? result.videoURL: result.descMsg];
    [self showErrorMessage:string];
    NSLog(@"onPublishComplete [%d/%@]", result.retCode, result.retCode == 0? result.videoURL: result.descMsg);
}

@end
