//
//  TVCIPMap.h
//  TXVodUpload
//
//  Created by kongdywang on 21.11.25.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface TVCIPMap : NSObject

/// Add an object to the array for the specified key
- (void)addObject:(id)object toArrayForKey:(id)key;

/// Remove an object from the array for the specified key
- (void)removeObject:(id)object fromArrayForKey:(id)key;

/// Get the array for the specified key (returns immutable copy)
- (nullable NSArray *)arrayForKey:(id)key;

/// Check if the dictionary contains the specified key
- (BOOL)containsKey:(id)key;

/// Get all keys in the dictionary
- (NSArray *)allKeys;

/// Get a copy of all arrays in the dictionary (each array is also immutable copy)
- (NSDictionary<id, NSArray *> *)allArrays;

/// Remove the array for the specified key
- (void)removeArrayForKey:(id)key;

/// Clear the entire dictionary (remove all keys and arrays)
- (void)clearAll;

/// Get the number of keys in the dictionary
- (NSUInteger)count;

/// Check if the dictionary is empty
- (BOOL)isEmpty;

#pragma mark - Batch Operations

/// Replace the content of the array for the specified key
- (void)replaceArrayForKey:(id)key withObjects:(NSArray *)objects;

@end

NS_ASSUME_NONNULL_END
