//
//  TVCIPMap.m
//  TXVodUpload
//
//  Created by kongdywang on 21.11.25.
//

#import "TVCIPMap.h"

@interface TVCIPMap()

@property(atomic, strong)NSMutableDictionary<id, NSMutableArray *> *dictionary;

@end

@implementation TVCIPMap

#pragma mark - Dictionary Operations

- (void)addObject:(id)object toArrayForKey:(id)key {
    // Validate input parameters
    if (!object || !key) return;
    
    @synchronized (self) {
        NSMutableArray *array = _dictionary[key];
        if (!array) {
            // Create new array if it doesn't exist for the key
            array = [NSMutableArray array];
            _dictionary[key] = array;
        }
        [array addObject:object];
    }
}

- (void)removeObject:(id)object fromArrayForKey:(id)key {
    // Validate input parameters
    if (!object || !key) return;
    
    @synchronized (self) {
        NSMutableArray *array = _dictionary[key];
        [array removeObject:object];
        
        // Remove the key if the array becomes empty
        if (array.count == 0) {
            [_dictionary removeObjectForKey:key];
        }
    }
}

- (NSArray *)arrayForKey:(id)key {
    if (!key) return nil;
    
    @synchronized (self) {
        // Return immutable copy to prevent external modification
        return [_dictionary[key] copy];
    }
}

- (BOOL)containsKey:(id)key {
    if (!key) return NO;
    
    @synchronized (self) {
        return _dictionary[key] != nil;
    }
}

- (NSArray *)allKeys {
    @synchronized (self) {
        return [_dictionary.allKeys copy];
    }
}

- (NSDictionary<id, NSArray *> *)allArrays {
    @synchronized (self) {
        NSMutableDictionary *result = [NSMutableDictionary dictionaryWithCapacity:_dictionary.count];
        [_dictionary enumerateKeysAndObjectsUsingBlock:^(id key, NSMutableArray *array, BOOL *stop) {
            // Each array returns as immutable copy
            result[key] = [array copy];
        }];
        return [result copy];
    }
}

- (void)removeArrayForKey:(id)key {
    if (!key) return;
    
    @synchronized (self) {
        [_dictionary removeObjectForKey:key];
    }
}

- (void)clearAll {
    @synchronized (self) {
        [_dictionary removeAllObjects];
    }
}

- (NSUInteger)count {
    @synchronized (self) {
        return _dictionary.count;
    }
}

- (BOOL)isEmpty {
    @synchronized (self) {
        return _dictionary.count == 0;
    }
}

#pragma mark - Batch Operations

- (void)replaceArrayForKey:(id)key withObjects:(NSArray *)objects {
    if (!key) return;
    
    @synchronized (self) {
        if (objects) {
            _dictionary[key] = [objects mutableCopy];
        } else {
            // Remove key if objects is nil
            [_dictionary removeObjectForKey:key];
        }
    }
}

@end
